#!/usr/bin/perl -w
use strict; 

# make sure the MOJO lib is in the lib paths!
use lib qw(./ ./MOJO ../ ../MOJO ../MOJO/perllib); 

# use some of those Modules
use MOJO::Config;
use MOJO::Template::HTML; 
use MOJO::App::Guts;

# we need this for cookies things
use CGI; 
my $q = new CGI; 

# this is how we find what list we're working on
my %login          = $q->cookie(-name => $LOGIN_COOKIE_NAME); 

my $admin_list     = $login{admin_list}               || undef; 
my $admin_password = $login{admin_password}           || undef; 


# This will take care of all out security woes
my $root_login = check_list_security(-Admin_List      => $admin_list, 
                                     -Admin_Password  => $admin_password, 
                                     -IP_Address      => $ENV{REMOTE_ADDR},
                                     -Function        => 'boilderplate');
my $list = $admin_list; 

# get the list information
my %list_info = open_database(-List => $list); 
                              
# header     
print(admin_html_header(-Title      => "Admin Plugin Example",
		                -List       => $list_info{list},
		                -Form       => 0,
		                -Root_Login => $root_login));
	
	               
if(!$q->param('process')){ 


print $q->p('I echo whatever you type in:') . 
      $q->start_form()                                        . 
      $q->textfield('echo')                                   . 
	  $q->hidden('process', 'true')                           .
	  $q->submit('echo away!')                                .
	  $q->end_form(); 
}else{ 

	print $q->h1($q->param('echo')); 
}


#footer
print admin_html_footer(-Form => 0); 


=pod

=head1 Roll Your Own Admin Screen

This should give you a good idea on how to extend Mojo Mail's admin area to do.... anything 

There is an example on how to make the actual admin screen + script, it's called 

B<boilerplate_plugin.cgi> 

and should be located in the B<mojo/extras/scripts/> directory It should work right out of the box, upload it, chmod 755 it and follow the next set of directions to make it work

=head2 Adding this Module to Mojo Mail

You'll need to tweak the $ADMIN_MENU variable in the Config.pm file, $ADMIN_MENU is a reference to an array of hashes of an array of hashes, or somewhere in there. 

Follow the pattern :) 

Adding this right after the last array ref entry: 

	 {-Title           => 'Boilder Plate Example', 
	   -Title_URL      => "plugins/boilerplate_plugin.cgi",
	   -Function       => 'boilderplate',
	   -Activated      => 1, 
	  },
	  
will do the trick, as long as you uploaded B<boilderplate_admin_module.cgi> in the same directory as mojo.cgi. It's better to give the absolute URL for these things, I think. Upload the revised Config.pm file and there should be a link for this very module. Pretty frickin cool, eh?

=cut


