package MOJO::Template::Widgets;

use lib qw(./ ../ ./mojo ../mojo ./MOJO ../MOJO); 

use MOJO::Config; 
use MOJO::App::Guts; 
use CGI; 
my $q = new CGI; 

require Exporter; 
@ISA    = qw(Exporter); 
@EXPORT = qw( list_popup_menu );

use strict; 
use vars qw( @EXPORT );


=pod

=head1 Name

MOJO::Template::Widgets

=head1 Description

Holds commonly used HTML 'widgets'

=head1 Subroutines

=cut


=pod

=head2 list_popup_menu

returns a popup menu holding all the list names as labels and 
list shortnames as values

=cut

sub list_popup_menu { 
	my %args = (-show_hidden => 0,
				-name        => 'list',
			    @_); 
	my $labels = {}; 
	
	foreach my $list( available_lists() ){
		my %li = open_database(-List => $list);
		next if $args{-show_hidden} == 0 && $li{hide_list} eq '1'; 
		$labels->{$list} = $li{list_name};
	}
	my @opt_labels = sort { uc($labels->{$a}) cmp uc($labels->{$b}) } keys %$labels;
	
	
	return $q->popup_menu( -name    => $args{-name}, 
						  '-values' => [@opt_labels],
						   -labels   => $labels,
						   -style    => 'width:200px'); 
}




1;




=pod

=head1 COPYRIGHT

Copyright (c) 1999 - 2003 Justin Simoni 
me@justinsimoni.com
http://justinsimoni.com 
All rights reserved. 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=cut
