package MOJO::Logging::Usage;

=pod 

=head1 NAME 

MOJO::Log 

=head1 DESCRIPTION


	my $log = new MOJO::Logging::Usage;
	
	$log->mj_log($list, $action, $details); 
	$log->trace("something's happening"); 


=head1 SYNOPSIS

This simple module allows simple logging utilities to Mojo Mail. It also allows you 
to 'trace' whatever you want really in Mojo Mail, This is best for bug fixing and usually 
isn't good for general use.

=cut 


use lib '../';
use MOJO::Config;
use Fcntl qw(LOCK_SH);


sub new {

	my $class = shift;
	my $self = {};			
	bless $self, $class;
		$self->open_log;
	return $self;
	
};

sub mj_log {
 
	my $self    = shift; 
	my $list    = shift || 'undefined'; 
	my $action  = shift || 'undefined'; 
	my $details = shift || ""; # this isn't mandatory i guess 
	my $time = scalar(localtime());
	if($MOJO_LOG){
		print LOG "[$time]\t$list\t$action\t$details\n";
	}	
}


sub trace { 

	my $self  = shift; 
	my $trace = shift; 
	my $time = scalar(localtime());
	if($MOJO_LOG){
		print LOG "[$time]\t[trace]\t$trace\n";
	}
}		


sub open_log { 

	if($MOJO_LOG){
		chmod($FILE_CHMOD, $MOJO_LOG); 
		open(LOG, ">>$MOJO_LOG") or warn "$PROGRAM_NAME $VER - i can't open my own log at '$MOJO_LOG', here's some details: $!";
		flock(LOG, LOCK_SH);
	}
}

sub close_log { 

	my $self = shift; 
	if($MOJO_LOG){
		close (LOG);
	}

}


sub DESTROY{ 

	my $self = shift; 
	if($MOJO_LOG){
		$self->close_log;
	}
	
}

1;


=pod

=head1 COPYRIGHT

Copyright (c) 1999 - 2003 Justin Simoni 
me@justinsimoni.com
http://justinsimoni.com 
All rights reserved. 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=cut
