package MOJO::Logging::Clickthrough; 

use strict; 

=head1 Name 

MOJO::Logging::Clickthrough

=head1 Description 

Holds methods that keep track of URLS clicked in Mailing List Messages. 

=cut


use lib '../';
use MOJO::Config;
use MOJO::App::Guts;

use Fcntl qw(LOCK_SH);


sub new {

	my $class = shift;
	my $self = {};			
	bless $self, $class;

	$self->{list} = shift;
	$self->{is_redirect_on} = $self->redirect_config_test; 	
	
	return $self;
};





sub redirect_config_test { 
	my $self = shift; 	
	
	return 0 if (!$self->{list}) || ($self->{list} eq ""); 
	return 0 unless MOJO::App::Guts::check_if_list_exists(-List => $self->{list}) >= 1;
	
	my %list_info = MOJO::App::Guts::open_database(-List => $self->{list});
	
	return 0 if $list_info{clickthrough_tracking} != 1;
	return 1;
}





sub r_log { 
	my ($self, $mid, $url) = @_;
	if($self->{is_redirect_on} == 1){ 
	    chmod($FILE_CHMOD, $self->clickthrough_log_location); 
		open(LOG, ">>" . $self->clickthrough_log_location) or warn $!;
		flock(LOG, LOCK_SH);
		print LOG scalar(localtime()) . "\t" . $mid . "\t" . $url . "\n";
		close (LOG);
		return 1; 
	}else{ 
		return 0;
	}
}



sub report_by_message_index { 
	my $self   = shift; 
	my $report = {}; 
	my $l;
	
	my %list_info = MOJO::App::Guts::open_database(-List => $self->{list});
	
	open(LOG, $self->clickthrough_log_location) or die $!; 
	while(defined($l = <LOG>)){ 
		chomp($l); 
		my ($t, $mid, $url) = split("\t", $l); 
	    $report->{$mid}->{count}++;		
	}
	close(LOG); 
	require MOJO::MailingList::Archives; 
	my $mja = MOJO::MailingList::Archives->new(-List => \%list_info); 
	foreach(sort keys %$report){ 
		$report->{$_}->{message_subject} = $mja->get_archive_subject($_) || $_;
	}
	return $report; 
	
}



sub report_by_message { 
	my $self      = shift; 
	my $match_mid = shift; 
	
	my $report = {}; 
	my $l;
	my %list_info = MOJO::App::Guts::open_database(-List => $self->{list});
	open(LOG, $self->clickthrough_log_location) or die $!; 
	while(defined($l = <LOG>)){ 
		chomp($l); 
		my ($t, $mid, $url) = split("\t", $l); 
		if($match_mid == $mid){ 
			$report->{$url}->{count}++;
		}
	}
	close(LOG); 
	return $report; 
}





sub report_by_url { 
	my $self      = shift; 
	my $match_mid = shift; 
	my $match_url = shift;
	
	my $report = []; 
	my $l;
	my %list_info = MOJO::App::Guts::open_database(-List => $self->{list});
	open(LOG, $self->clickthrough_log_location) or die $!; 
	while(defined($l = <LOG>)){ 
		chomp($l); 
		my ($t, $mid, $url) = split("\t", $l); 
		if(($match_mid == $mid) && ($match_url eq $url)){ 
			push(@$report, $t);
		}
	}
	close(LOG); 
	return $report; 
}


sub print_raw_logs { 
	my $self = shift; 
	my $l; 
	open(LOG, $self->clickthrough_log_location) or die $!; 
	while(defined($l = <LOG>)){ 
		chomp($l); 
		print $l . "\n";
	}
}



sub clickthrough_log_location { 
	my $self = shift; 
	my $ctl  =  $LOGS . '/' . $self->{list} . '-clickthrough.log';
	   $ctl  = MOJO::App::Guts::make_safer($ctl);
	   $ctl =~ /(.*)/;
	   $ctl = $1; 
	   return $ctl; 
}

1;





=pod

=back 


=head1 COPYRIGHT

Copyright (c) 1999 - 2003 Justin Simoni 
 me@justinsimoni.com
 http://justinsimoni.com 
 All rights reserved. 

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=cut

