package MOJO::Log;

=pod 

=head1 NAME 

MOJO::Log 

=head1 DESCRIPTION


	my $log = new MOJO::Log;
	
	$log->mj_log($list, $action, $details); 
	$log->trace("something's happening"); 


=head1 SYNOPSIS

This simple module allows simple logging utilities to Mojo Mail. It also allows you 
to 'trace' whatever you want really in Mojo Mail, This is best for bug fixing and usually 
isn't good for general use.

=cut 


use lib '../';
use MOJO::Config;
use Fcntl qw(LOCK_SH);


sub new {

	my $class = shift;
	my $self = {};			
	bless $self, $class;
		$self->open_log;
	return $self;
	
};

sub mj_log {
 
	my $self    = shift; 
	my $list    = shift || 'undefined'; 
	my $action  = shift || 'undefined'; 
	my $details = shift || ""; # this isn't mandatory i guess 
	my $time = scalar(localtime());
	if($MOJO_LOG){
		print LOG "[$time]\t$list\t$action\t$details\n";
	}	
}


sub trace { 

	my $self  = shift; 
	my $trace = shift; 
	my $time = scalar(localtime());
	if($MOJO_LOG){
		print LOG "[$time]\t[trace]\t$trace\n";
	}
}		


sub open_log { 

	if($MOJO_LOG){
		chmod($FILE_CHMOD, $MOJO_LOG); 
		open(LOG, ">>$MOJO_LOG") or warn "$PROGRAM_NAME $VER - i can't open my own log at '$MOJO_LOG', here's some details: $!";
		flock(LOG, LOCK_SH);
	}
}

sub close_log { 

	my $self = shift; 
	if($MOJO_LOG){
		close (LOG);
	}

}


sub DESTROY{ 

	my $self = shift; 
	if($MOJO_LOG){
		$self->close_log;
	}
	
}

1;


=pod

=head1 CHANGES 

=over4 

=item B<5/29/01> - add the trace method, added POD  

=back

=cut
