#!/usr/bin/perl -w
use strict; 

# make sure the MOJO lib is int he lib paths!
use lib qw(./ ./MOJO ../ ../MOJO); 

# use some of those Modules
use MOJO::Config;
use MOJO::HTML; 
use MOJO::Guts;

# we need this for cookies things
use CGI; 
my $q = new CGI; 

# this is how we find what list we're working on
my %login          = $q->cookie(-name => 'login'); 
my $admin_list     = $login{admin_list}               || undef; 
my $admin_password = $login{admin_password}           || undef; 


# This will take care of all out security woes
my $root_login = check_list_security(-Admin_List      => $admin_list, 
                                     -Admin_Password  => $admin_password, 
                                     -IP_Address      => $ENV{REMOTE_ADDR},
                                     -Function        => 'view_list_settings');
my $list = $admin_list; 

# get the list information
my %list_info = open_database(-List => $list); 
                              
# header     
print(admin_html_header(-Title      => "View List Settings",
		                -List       => $list_info{list},
		                -Form       => 0,
		                -Root_Login => $root_login));

#
#
#
#	               
eval require HTML::Entities; 

if(!$@){ 
	foreach(sort keys %list_info){ 
		print $q->p($q->b($_)); 
		print $q->hr; 
		my $e_settings = HTML::Entities::encode_entities($list_info{$_}, "\200-\377");
		   $e_settings =~ s/>/\&gt;/g;
		   $e_settings =~ s/</\&lt;/g;	
		#special case
		if($_ eq 'admin_menu'){ 
			$e_settings =~ s/;/;\n/g;
		}
			
		print $q->pre($e_settings);
		print $q->hr;
	}
}else{ 
	print $q->p($q->b('I need the HTML::Entities module installed for this plugin to work!')); 
}

#
#
#
#



#footer
print admin_html_footer(-Form => 0); 


__END__

=pod

=head1 View List Settings 

This plugin allows you to view what ALL your list settings are set to

=head2  $ADMIN_MENU ENTRY

	 {-Title      => 'View List Settings', 
	  -Title_URL  => "plugins/view_list_settings.cgi",
	  -Function   => 'view_list_settings',
	  -Activated  => 1, 
	  },
  
=cut


