package MOJO::Error;


=pod

=head1 NAME 

MOJO::Error

=head1 SYNOPSIS

	use MOJO::Error

This module basically has error messages in HTML and spits 'em back at ya

=cut


use lib './'; 
use lib '../'; 

use MOJO::Config; 
use MOJO::Guts; 
use MOJO::HTML;

require Exporter; 
@ISA = qw(Exporter); 
@EXPORT = qw(cgi_user_error);
use strict; 
use vars qw(@EXPORT);
my %error;

require CGI;
my $q = new CGI; 

if(($MOJO_URL eq "") || ($MOJO_URL eq 'http://www.aiagentz.com/cgi-bin/kas/mojo/mojo.cgi')){ 
			$MOJO_URL = $q->script_name(); 
}
		


$error{no_list} = <<EOF

<h3>I Couldn't Find List ([list_name])</h3> 
<p>I had trouble fetching [list_name] from this server. 
It's possible that it has been deleted or moved 
and the form you used is a bit out of date.</p> 
EOF
;


$error{invalid_password} = <<EOF

<h3>Your Password is Incorrect</h3> 
<p>The password you gave me doesn't seem to be correct. 
You might have typed it in wrong. Try typing it in again. 
If you forgot your password, have it emailed back to you.</p> 

<p><b>Try signing into [list_name] again</b></p>
<input type=hidden name=flavor value="login">
<p><input type="hidden" name="admin_list" value="[list]">
<input type=password name=admin_password> 
<input type=submit style='$STYLE{default_submit}' value="Login"></p>
</form> 

<form action=$MOJO_URL method=POST> 
<input type=hidden name=flavor value="email_password">
<input type=hidden name=list value="[list]">
<center><p><input type=submit style='$STYLE{default_submit}' value = "Mail [mojo_email] The Password">

</p></center> 


<p>If you keep getting bounced back to this screen, 
make sure that cookies are turned 'on' 
in your web browser. </p> 

EOF
; 

$error{need_to_login} = <<EOF

<h3>You Need to Log in</h3> 
<p>I didn't catch name of your  list or its  password.
I need those to let you into your administration control panel.</p>

<p><b>Sign into your list:</b></p>

<input type="hidden" name=flavor value="login">
<p>
 [list_option_form]
 <input type="password" name="admin_password"> 
 <input type=submit style='$STYLE{default_submit}' value="Login"></p>  

EOF
;


$error{email_in_list} = <<EOF  

<h3>Your email is already in the list</h3> 

<p>It seems that your email, <a href=mailto:[email]>[email]</a> is already in [list_name].</p> 
<p>Its possible that the list owner already put your address in the list, or you 
just clicked your confirmation link twice. </p> 

EOF
;


$error{email_not_in_list} = <<EOF  

<h3>Your email is not in the list</h3> 

<p>It seems that your email, <a href=mailto:[email]>[email]</a> is not in [list_name].</p> 
<p>Its possible that the list owner deleted  your address from the list, or you 
just clicked your unsubscription link twice. </p>
<p>Press your <a href=# onclick=history.back()>back button</a> to enter your e-mail address again.</p> 

EOF
;


$error{invalid_email} = <<EOF 

<h3>Invalid Email Address</h3> 
<p>The address you gave, <a href=mailto:[email]>[email]</a>
doesn't seem to pass our verification. It's possible that you just typed it in
wrong. Try typing it again:</p> 

<p><b>Sign up for [list_name]:</b><br> 
 <input type=hidden name=flavor value="subscribe"> 
 <input type=hidden name=list value="[list]"> 
 <input type="text" name=email value="[email]"> 
 <input type=submit style='$STYLE{default_submit}' value="Subscribe!"> 
</p>

EOF
; 

$error{mx_lookup_failed} = <<EOF 

<h3>Invalid Email Address</h3> 
<p>The address you gave, <a href=mailto:[email]>[email]</a>
doesn't seem to pass our verification because we couldn't find the hostname.
It's possible that you just typed it in
wrong. Try typing it again:</p> 

<p><b>Sign up for [list_name]:</b><br> 
 <input type=hidden name=flavor value="subscribe"> 
 <input type=hidden name=list value="[list]"> 
 <input type="text" name=email value="[email]"> 
 <input type=submit style='$STYLE{default_submit}' value="Subscribe!"> 
</p>

EOF
; 



$error{pass_no_match} = <<EOF 

<h3>Your New Password Doesn't Match.</h3> 
 <p>The new password you typed, isn't the same the second time you typed it or you didn't enter a new password at all. 
    You probably just made a simple mistake</p> 

 <p>Press the back button the fix the problem</p> 

EOF
; 

$error{invalid_pin} = <<EOF 

<h3>Invalid Pin Number</h3> 
 <p>The pin number you gave wasn't correct for your email address. 
    You might have copied the confirmation or unsubscription address incorrectly. 
    Be sure to copy the entire address into the address bar in your browser. 
 </p>

EOF
; 


$error{invalid_root_password} = <<EOF 

<h3>Your Root Password is Incorrect</h3> 
 <p>The root password you gave me didn't match up to the one one i have for 
    your $PROGRAM_NAME script. Please try again:</p> 

 <p><b>Root Password<b><br> 
  <input type=hidden name=flavor value="new_list">
  <input type = password name=root_password> 
  <input type="submit" style='$STYLE{default_submit}' value="log in as $PROGRAM_NAME root"> 
  
EOF
;


$error{bad_ip} = <<EOF
<p>You are not allowed to log into your list control panel from your present IP Address.</p> 
EOF
; 


$error{no_archive_entry} = <<EOF
<h3>Entry Not Available</h3> 
 <p>The Archived message you're trying to find isn't there.</p>
EOF
; 


$error{no_archive} = <<EOF
<h3>No archive for [list_name]</h3> 
 <p>I couldn't find an archive for [list_name], the archive database 
    might be corrupted, or you never sent a message to be archived.</p>     
EOF
; 


$error{list_already_exists} = <<EOF
<h3>The List Name [list_name] already exists</h3> 
 <p>So not to overwrite the list that's already set up, pick a new name.</p> 
EOF
; 

$error{no_show_archives} = <<EOF 
<h3>No Archived Messages</h3> 
 <p>There are no messages archived for this list that are available to be viewed</p>
EOF
; 


$error{closed_list} = <<EOF 
<h3>Unable to Subscribe</h3> 
<p>This list you are trying to subscribe to is closed. Only the list administrator can subscribe people to the list.</p>
EOF
; 


$error{stupid_programmer} = <<EOF 
<h3>Stupid, Stupid Programmer</h3> 
<p>um, i have no idea whats wrong with what, whatever you did, um... 
i'd close all programs and restart, usually that does the trick, you might want to give me a 
word or two about my laziness, write to:</P> 
<p><a href=mailto:justin\@skazat.com>justin\@skazat.com> and tell me how 
i should just stick to drawing pretty pictures. 
</p> 
<p>*thanks*</p> 
EOF
; 


$error{no_permissions_to_write} = <<EOF 
<h3>Can't Create a New List</h3> 
<p>It seems I'm having trouble writing a new list to the 
directory you specified your lists to be: </p> 
<p><b>$FILES</b></p> 
<p>this might be because that directory doesn't exist, or 
I don't have permission to write to it. Make sure the directory path is
correct. If your still getting this error, chmod 777 the directory
and then setup a new list.</p> 
EOF
; 

$error{black_listed} = <<EOF 
<h3>You Are Unable to Subscribe</h3> 
<p>It seems that your not allowed to subscribe to [list_name] for some reason or another.
This list may be closed to 
particular participants</p> 
EOF
;

$error{too_busy} = <<EOF 
<h3>$PROGRAM_NAME - Too Busy</h3> 
<p>Our apologies, but the server is too overloaded to take your request. 
Please try again in a few minutes and see if the server status has cleared up.</p> 
EOF
;

$error{no_admin_permissions} = <<EOF

<h3>Sorry,</h3> 
<p>You do not have the correct permissions to access this control panel. Take it up wid management</p> 
EOF
; 


$error{no_root_password} = <<EOF

<h3>No Root Password Set</h3> 
<p>The Mojo Root Password has <b>not</b> been set to a valid value. List creation is not 
allowed with the Mojo Root Password left blank</p> 

EOF
; 




$error{bad_setup} = <<EOF

<h3>Yikes!</h3> 

<p>Mojo Mail was <b>not set up</b> properly.</p> 

<p><a href="$MOJO_URL?f=setup_info">Click here</a> for more information</p>
 
EOF
; 





=pod

=head1 SUBROUTINES

=head2 cgi_user_error

	print cgi_user_error(-List => 'my_list', -Error => 'some_error', -Email => 'some@email.com'); 

Gives back an HTML friendly error message

=cut



sub cgi_user_error { 
	my %args = (-List => undef, 
     			-Error => undef, 
     			-Email => undef, 
     			@_); 
    my $return_html;  			 
	
	my  $available_lists_ref; 
	my %list_info = (); 
	my $list_exists;
	my $list_popup_menu; 
	
	if($args{-Error} ne 'bad_setup'){
		$available_lists_ref = available_lists(-As_Ref=>1);
		$list_exists = check_if_list_exists(-List=>$args{-List});
	if($list_exists > 0) { 
		%list_info = open_database(-List => $args{-List}); 
	}else{ 
		%list_info = (); 
	}
	
	}


	
	

	my $list_exists;
	
	if($args{-Error} ne 'bad_setup'){			
		$list_exists = check_if_list_exists( -List=> $args{-List});
		if($list_exists > 0) { 
			%list_info = open_database(-List => $args{-List}); 
		}else{ 
			%list_info = (); 
		}
	}
	
	$return_html .= (the_html(-Part  => "header",
							  -Title => "There seems to be a problem", 
							  -List  => $list_info{list}));
	

    if(defined($error{$args{-Error}})) { 
         my $error_msg = $error{$args{-Error}}; 
            $error_msg = interpolate_string(-String => $error_msg, -List_Db_Ref => \%list_info);
            
         require MOJO::Widgets; 
		 $list_popup_menu =  MOJO::Widgets::list_popup_menu(-name => 'admin_list', -show_hidden => 1) if($args{-Error} ne 'bad_setup'); 
            $error_msg =~ s/\[list_option_form\]/$list_popup_menu/g;
            $error_msg =~ s/\[email\]/$args{-Email}/g;            
         $return_html .= $error_msg;
    }else{ 
         $return_html .= $args{-Error};        
    } 

	if($args{-Error} eq 'bad_setup'){ 
	
		my $error_report; 
		my @tests = ($FILES, $TEMPLATES, $TMP);
		my %sift; 
		foreach(@tests){$sift{$_}++}
		@tests = keys %sift; 
		
		foreach my $test_dir(@tests){ 
			open(TEST, $test_dir) or warn $!; 
			unless(-d TEST){ 
				$error_report .= "<p>'$test_dir' is <b>NOT</b> a directory.</p>\n"; 
			}
			unless(-e TEST){ 
				$error_report .= "<p>'$test_dir' <b>DOES NOT</b> exist.</p>\n"; 			
			}
		}
		
		$return_html .= $error_report;
	}
	
	
	if ($list_exists > 0) { 
		 $return_html .= "<p>You might want to e-mail the list owner at: "; 
		 $return_html .= "<a href = mailto:$list_info{mojo_email}>$list_info{mojo_email}</a> with your problem</p>"; 
	}

  
  
 $return_html .= (the_html(
					-Part      => "footer",
					-List      => $list_info{list},
					-Site_Name => $list_info{website_name},
					-Site_URL  => $list_info{website_url},
					 ));


return $return_html;
}
