package MOJO::Widgets;

use lib qw(./ ../ ./mojo ../mojo ./MOJO ../MOJO); 

use MOJO::Config; 
use MOJO::Guts; 
use CGI; 
my $q = new CGI; 

require Exporter; 
@ISA    = qw(Exporter); 
@EXPORT = qw( list_popup_menu );

use strict; 
use vars qw( @EXPORT );

sub list_popup_menu { 
	my %args = (-show_hidden => 0,
				-name        => 'list',
			    @_); 
	my $labels = {}; 
	
	foreach my $list( available_lists() ){
		my %li = open_database(-List => $list);
		next if $args{-show_hidden} == 0 && $li{hide_list} eq '1'; 
		$labels->{$list} = $li{list_name};
	}
	my @opt_labels = sort { uc($labels->{$a}) cmp uc($labels->{$b}) } keys %$labels;
	
	
	return $q->popup_menu( -name    => $args{-name}, 
						  '-values' => [@opt_labels],
						  -labels   => $labels,
						  -style    => 'width:200px'); 
}
