#!/usr/bin/perl -w 
use strict; 
use lib qw(./ ./MOJO ../ ../MOJO mojo mojo/MOJO); 


# After testing, set $Debug to '0'
my $Debug  = 0;

# A small message afterwards
my $Thanks = "<p>Thank you for subscribing to our lists</p>";

# How many columns should the checkbox list be?
my $Checkbox_Columns = 2;

# There isn't anything else serviceable in this script.



#---------------------------------------------------------------------#


use CGI qw(:standard html3); 
use CGI::Carp "fatalsToBrowser"; 

require MOJO::Guts; 
use MOJO::Config;
use MOJO::List; 
use MOJO::HTML;



#---------------------------------------------------------------------#




my $q = CGI->new(); 
my $email           = $q->param('email')       || $q->param('e'); 
my $flavor          = $q->param('flavor')      || $q->param('f'); 
my @lists           = $q->param('lists')       || $q->param('ls');
my $list            = $q->param('list')        || $q->param('l')  || $DEFAULT_LIST;    
my $redirect_url    = $q->param('redirect_url'); 
my @available_lists = MOJO::Guts::available_lists(); 
my %list_names; 

foreach(@available_lists){ 
	my %li = MOJO::Guts::open_database(-List => $_); 
	$list_names{$_} = $li{list_name};
}

&main; 


#---------------------------------------------------------------------#


sub main { 
	if($lists[0]){
		subscribe_emails(); 
	}else{ 
		subscription_form(); 
	}
}




sub subscription_form { 

# create the initial form
print header(); 
print(the_html(-Part       => "header",
			   -Title      => "Subscribe to Multiple Lists", 
			   -List       => $list,
			   -Start_Form => 0));  
print end_form(), start_form(-method => 'POST'), 
      p('Choose what lists you want to subscribe to:', br(), 
      checkbox_group(-name      => 'ls', 
       				 '-values'  => \@available_lists, 
       				 -labels    => \%list_names,
       				 -linebreak =>'true',
       				 -columns   => $Checkbox_Columns,
       				 )), 
      p('Your email address:', br(), 
      textfield(-name=> 'e'),
      submit(-value  => 'Subscribe',
              '-style' => $STYLE{green_submit})), 
      endform();   
	print(the_html(-Part     => "footer", 
				   -List     => $list,
				   -End_Form => 0)); 

}

sub subscribe_emails {

	#--- debug! --- #
	print $q->header, $q->h1('Debug Mode'), $q->hr if $Debug == 1; 
	
	foreach my $this_list(@lists){ 
		my $lh = MOJO::List->new(-List => $this_list); 
		my ($status, $errors) = $lh->subscription_check(-Email => $email); 
		#--- debug! --- #
		print $q->h2("List: '" . $this_list ."', Email: $email, Status: " . $q->b($status)) if $Debug == 1; 
		
		if($status == 1){ 
			send_confirmation(-Email => $email, -List => $this_list, -List_Obj => $lh); 
		}else{ 
			#--- debug! --- #
			if($Debug == 1){ 
				print $q->h3("Details..."); 
				print '<ul>';
				foreach my $error(keys %$errors){ 
					print $q->li($error); 
				}
				print '</ul>';
			}else{ 
				# nothing.	
			}
		}	
	}
	if($Debug != 1){
		if($redirect_url){ 
			print $q->redirect(-uri => $redirect_url); 
		}else{ 
			print $q->header;
			print(the_html(-Part  => "header",
			   -Title => "Subscribe to Multiple Lists", 
			   -List  => $list,
			   -Start_Form => 0)); 
			print $Thanks;   
			print(the_html(-Part     => "footer", 
				  		   -List     => $list,
				  		   -End_Form => 0));   
			   
		}
	}
}



sub send_confirmation { 

	
	my %args = (-Email    => $email, 
				-List     => undef, 
				@_); 
	
	my $sub_email = $args{-Email};
	my $list      = $args{-List};
	my $lh        = $args{-List_Obj}; 
	
	my %list_info = MOJO::Guts::open_database(-List => $list);
						
						
	if($list_info{no_confirm_email}  eq "0"){ 
		
		#--- debug! --- #
		print $q->h2("List: $list, Email: $sub_email, Subscribed.") if $Debug == 1;
		
		$lh->add_to_email_list(-Email_Ref => [$sub_email], -List => $list); 
		
	}else{ 			

		my $Body = $list_info{confirmation_message}; 
				
		my $subscribe_link = MOJO::Guts::subscribe_link(-list     => $list,
											-email    => $sub_email,
											-make_pin => 1);
		
		my $unsubscribe_link = MOJO::Guts::unsubscribe_link(-list     => $list,
												-email    => $sub_email,
												-make_pin => 1);
									    		
		$Body =~ s/\[list_unsubscribe_link\]/$unsubscribe_link/g; 
		$Body =~ s/\[list_subscribe_link\]/$subscribe_link/g;
		 
		$Body = MOJO::Guts::interpolate_string(-String      => $Body, 
		                    			       -Email       => $sub_email,
 											   -List_Db_Ref => \%list_info);							
		
		
		require MOJO::Mail;  
		my $mh = MOJO::Mail->new(\%list_info); 
		my %mailing = (
			#'Content-Type'  => "$list_info{content_type}; charset=$list_info{charset_value}",
			To              => "$sub_email", 
			Subject         => "$list_info{list_name} Mailing List Confirmation", 
			Body            => $Body
					);
		$mh->send(%mailing); 
		
		#--- debug! --- #
		print $q->h2("List: $list, Email: $sub_email, Confirmation Sent.") if $Debug == 1;
		
	}			
					
}	

__END__


=pod

=head1 NAME multiple_subscribe.cgi

=head1 INSTALLING

upload this script in plaintext, or ASCII, mode into the same directory as 
mojo.cgi. chmod 755 the multiple_subscribe.cgi script.

You are good to go. 

View this script in a web browser, if everything is installed correctly, you 
should see a simple subscription form. 

=head1 Making an HTML form

This script takes two different arguments; B<list> and B<email>. Thusly, you have to 
make an HTML form that will supply this script with these two arguments: 

	<form action="multiple_subscribe.cgi" method="post"> 
	 <p>Lists:</p> 
	  <input type="checkbox" name="list" value="first_list" /> My first list<br/>
	  <input type="checkbox" name="list" value="second_list" /> My second list<br/>
	  <input type="checkbox" name="list" value="third_list" /> My third list<br/>
	 <p>Your email:</p> 
	 <input type="text" name="email" />
	 <input type="submit" value="Subscribe Me" /> 
	</form> 

You can also view the source of the initial screen of multiple_subscribe.cgi 
and copy and paste the form it creates. 

This script also takes an optional argument, B<redirect_url> that you may 
set to any URL where you'd like this script to redirect, once it's done:

	<input type='hidden' name='redirect_url' value='http://mysite.com/thanks.html'>

=head1 DEBUGGING

This script has one variable on top of the script, called B<$Debug>.
You may set this variable to '1' to gain a better insight on what exactly is
happening behind the curtains. 

=head1 COPYRIGHT 

Copyright (c) 1999 - 2003 
Justin Simoni
me@justinsimoni.com http://justinsimoni.com

All rights reserved. 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


=cut