<%@ page import="ejb.*" %>
<%@ page import="xml.*" %>
<%@ page import="util.*" %>
<%@ page import="model.*" %>
<%@ include file="header.jsp" %>
<%@ include file="forum_menu.jsp" %>
<%
  String j_uri = request.getParameter("j_uri");
  if (j_uri == null) j_uri = "forum.jsp";

  if (request.getUserPrincipal() == null) {
    response.sendRedirect(j_uri);
    return;
  } 

  UserModel u = new UserModel();
  String error = "";

  FormGetter.getFields(u, request);

  if (u.action.length() == 0) {
    u.fullName = user.getFullNameExt();
    u.email = user.getEmail();
    u.notify = user.getNotify();
  } else {
    boolean changePassword = ! ("".equals(u.password) && "".equals(u.passwordConfirm));
    if (changePassword) {
      if ("".equals(u.password))
        error += "- new password required<br>";  
      else if (! u.password.equals(u.passwordConfirm))
        error += "- incorrect password confirmation<br>";
    }
    if ("".equals(u.fullName))
      error += "- full name required<br>";
    if ("".equals(u.email))
      error += "- e-mail required<br>";
    if ("".equals(error)) {
      try {
        user.setFullName(u.fullName);
        user.setEmail(u.email);
        user.setNotify(u.notify);
        if (changePassword) 
          user.setPassword(u.password);
        response.sendRedirect(j_uri);
        return;
      } catch (Exception ex) {
        error += "- " + ex.getMessage() + "<br>";
      }
    }
  }
%>
<% if (! "".equals(error)) { %>
<table align="center">
<tr><td align="left"><b>ERROR:</b><br><%=error%></td></tr>
</table>
<% } %>

<form name="registerForm" method="post">
<input type="hidden" name="action" value="updateProfile">
<table border="1" cellpadding="5" cellspacing="0" align="center">
  <tr>
    <th>Login Name:</th>
    <td><%=user.getName()%></td>
  </tr>
  <tr>
    <th>Password:</th>
    <td><input type="password" name="password" maxlength="20" style="width:100%"></td>
  </tr>
  <tr>
    <th>Confirm Password:</th>
    <td><input type="password" name="passwordConfirm" maxlength="20" style="width:100%"></td>
  </tr>
  <tr>
    <th>Full Name:</th>
    <td><input type="text" name="fullName" maxlength="50" style="width:100%" value="<%=u.fullName%>"></td>
  </tr>
  <tr>
    <th>E-mail:</th>
    <td><input type="text" name="email" maxlength="100" style="width:100%" value="<%=u.email%>"></td>
  </tr>
  <tr>
    <th>E-mail notification:</th>
    <td><select name="notify" style="width:100%">
      <option value="true"<% if (u.notify) out.print(" selected"); %>>Yes</option>
      <option value="false"<% if (!u.notify) out.print(" selected"); %>>No</option>
    </select></td>
  </tr>
  <tr>
    <th>Registration date:</th>
    <td><%=Format.dateTime(user.getRegistered())%></td>
  </tr>
  <tr>
    <th>Previous login date:</th>
    <td><%=Format.dateTime(user.getPrevLogin())%></td>
  </tr>
  <tr>
    <th>Previous login address:</th>
    <td><%=user.getPrevAddress()%></td>
  </tr>
  <tr>
    <td align="center" colspan="2">
    <a href="javascript:document.registerForm.submit()"><img src="/btn/Submit.gif" border="0" alt="Submit" title="Submit"></a>
    &nbsp;
    <a href="javascript:window.history.back()"><img src="/btn/Cancel.gif" alt="Cancel" title="Cancel" border="0"></a>
    </td>
  </tr>
</table>
</form>
<%@ include file="footer.jsp" %>
