<%@ page import="security.*" %>
<%@ page import="ejb.*" %>
<%@ page import="xml.*" %>
<%@ page import="util.*" %>
<%@ page import="java.io.*" %>
<%@ page import="java.util.*" %>
<%
  String error = null;
  Vector attachments;
  
  if (session.getAttribute("fileRemover") == null)
    session.setAttribute("fileRemover", new FileRemover());
        
  if ((request.getParameter("action") == null) || (session.getAttribute("attachments") == null)) {
    attachments = new Vector();
    session.setAttribute("attachments", attachments);
  } else {
    attachments = (Vector)session.getAttribute("attachments");
  }
  if ("attachFile".equals(request.getParameter("action"))) {
    try {
      String fileName = TextProcessor.extractFileName(request.getParameter("file.filename"));
      if (!attachments.contains(fileName)) {
        File dir = new File(System.getProperty("app.path") + "WEB-INF/tmp/" + session.getId());
        dir.mkdirs();
        FileInputStream is = new FileInputStream(request.getParameter("file"));
        FileOutputStream os = new FileOutputStream(dir.getAbsolutePath() + "/" + fileName);
        byte[] buf = new byte[8192];
        for (int n = is.read(buf); n >= 0; n = is.read(buf)) {
          os.write(buf, 0, n);
        }
        is.close();
        os.close();
        attachments.add(fileName);
      }
    } catch(Exception e) {
      e.printStackTrace();
    }
  } else if ("detachFile".equals(request.getParameter("action"))) {
    try {
      int fileNum = Integer.parseInt(request.getParameter("fileNum"));
      String fileName = (String)attachments.get(fileNum);
      File f = new File(System.getProperty("app.path") + "WEB-INF/tmp/" + session.getId() + "/" + fileName);
      f.delete();
      attachments.remove(fileNum);
    } catch (Exception ex) { }
  } else if ("createTopic".equals(request.getParameter("action"))) {
    ForumCtrl ctrl = EJBGetter.getForumCtrlHome().create();
    try {
      Topic topic = ctrl.createTopic(request);
      response.sendRedirect("/forum_intopic.jsp?topicId=" + topic.getId());
      for (int i = 0; i < attachments.size(); i++) {
        File f;
        f = new File(System.getProperty("app.path") + "files/" + topic.getId());
        f.mkdirs();
        String fileName = (String)attachments.get(i);
        f = new File(System.getProperty("app.path") + "WEB-INF/tmp/" + session.getId() + "/" + fileName);
        f.renameTo(new File(System.getProperty("app.path") + "files/" + topic.getId() + "/" + fileName));
        Attachment att = EJBGetter.getAttachmentHome().create(topic, f.getName());
      }
      session.removeAttribute("attachments");
      return;
    } catch (ControlException ex) {
      error = ex.getMessage();
    } finally {
      ctrl.remove();
    }
  }
%>
<%@ include file="header.jsp" %>
<%@ include file="forum_menu.jsp" %>
<%
  int priv = forum.getCurrentPrivilege();
  if (priv < Privilege.WRITE) {
    String j_uri = request.getRequestURI();
    if (request.getQueryString() != null)
      j_uri += "?" + request.getQueryString();
    response.sendRedirect("/login.jsp?j_uri=" + response.encodeURL(j_uri));
  }
  String subject = TextProcessor.normStr(request.getParameter("subject"));
  String text = TextProcessor.normStr(request.getParameter("text"));
  int forumId = -1;
  int topicId = -1;
  if (topic != null) {
    topicId = topic.getId();
    forumId = topic.getForum().getId();
    if (text.length() == 0) {
      text = topic.getText();
      text = TextProcessor.postProcess(text);
      text = TextProcessor.reply(text);
      text = topic.getUser().getFullNameExt() + " wrote:" + System.getProperty("line.separator") + text;
    }
    if (subject.length() == 0) {
      subject = topic.getSubject();
      if (!subject.matches("^\\s*RE\\:.*$")) {
        subject = "RE:" + subject;
      }
    }
  } else if (forum != null) {
    forumId = forum.getId();
  }
%>
<script language="JavaScript">
function insertIcon(icon) {
  document.topicForm.text.value += icon;
  document.topicForm.text.focus();
}
function attachFile() {
  document.topicForm.action.value = "attachFile";
  document.topicForm.submit();
  return true;
}
function detachFile(fileNum) {
  document.topicForm.action.value = "detachFile";
  document.topicForm.fileNum.value = fileNum;
  document.topicForm.submit();
  return true;
}
function createTopic() {
  document.topicForm.action.value = "createTopic";
  document.topicForm.submit();
  return true;
}
</script>
<table border="0" cellpadding="0" cellspacing="0" width="100%">
<% if (error != null) { %>
  <tr>
    <td class="wtext"><br><b>Error: </b><%=error%><br><br></td>
  </tr>
<% } %>
<% if ((topicId == -1) && (forumId == -1)) { %>
  <tr>
    <td class="wtext"><br><b>Error: </b>Topic does not exist<br><br></td>
  </tr>
<% } else { %>
  <form name="topicForm" method="post" enctype="multipart/form-data">
  <input type="hidden" name="action" value="">
  <input type="hidden" name="fileNum" value="">
  <input type="hidden" name="topicId" value="<%=topicId%>">
  <input type="hidden" name="forumId" value="<%=forumId%>">
  <tr>
    <td>
      <b>Subject:</b><br>
      <input type="text" name="subject" maxlength="100" style="width:100%" value="<%=subject%>">
    </td>
  </tr>
<%
  if (!attachments.isEmpty()) {
%>
  <tr><td>
    <br><b>Attachments:</b>
    <table border="0" cellpadding="0" cellspacing="0">
<%
  for (int i = 0; i < attachments.size(); i++) {
    out.print("<tr><td>");
    out.print(attachments.get(i).toString());
    out.print("</td><td><img src='/img/sp.gif' width='10' height='1'></td><td>");
    out.print("<input type='button' class='btn' value='Delete' onclick='javascript:detachFile(" + i + ");'>");
    out.println("</td></tr>");
  }
%>
    </table>
  </td></tr>
<%
  }
%>
  <tr>
    <td>
      <br><b>Text:</b><br>
      <textarea name="text" style="width:100%; height:300px; font-family: Courier,monospace; font-size:12px;"><%=text%></textarea>
    </td>
  </tr>
  <tr valign="bottom">
    <td valign="bottom" style="vertical-align:bottom;height:0px;">
    <a href="javascript:insertIcon(':)');"><img src="emoticons/smile.gif" border=0></a>
    <a href="javascript:insertIcon(':(');"><img src="emoticons/frown.gif" border=0></a>
    <a href="javascript:insertIcon('0]');"><img src="emoticons/alien.gif" border=0></a>
    <a href="javascript:insertIcon('8)');"><img src="emoticons/glasses.gif" border=0></a>
    <a href="javascript:insertIcon('8o');"><img src="emoticons/nerd.gif" border=0></a>
    <a href="javascript:insertIcon(':b');"><img src="emoticons/tongue.gif" border=0></a>
    <a href="javascript:insertIcon(':D');"><img src="emoticons/happy.gif" border=0></a>
    <a href="javascript:insertIcon(';)');"><img src="emoticons/wink.gif" border=0></a>
    <a href="javascript:insertIcon(':o');"><img src="emoticons/embarassed.gif" border=0></a>
    <img src="/img/sp.gif" height="5" width="50">
    <b>File:</b> <input type="file" name="file"> <input type="button" class="btn" value="Attach" onclick="javascript:attachFile();">
    <img src="/img/sp.gif" height="5" width="50">
    <input type="button" class="btn" onclick="javascript:createTopic();" value="Submit">
<% if (topic != null) { %>
    <input type="button" class="btn" onclick="javascript:window.location.href='/forum_intopic.jsp?topicId=<%=topic.getId()%>';" value="Cancel">
<% } else { %>
    <input type="button" class="btn" onclick="javascript:window.location.href='/forum_topics.jsp?forumId=<%=forum.getId()%>';" value="Cancel">
<% } %>
    </td>
  </tr>
  </form>
  <tr>
    <td align="right">
    </td>
  </tr>
<script language="JavaScript">
  document.topicForm.subject.focus();
</script>
<% } %>
</table>
<%@ include file="footer.jsp" %>
