<%@ page import="security.*" %>
<%@ page import="ejb.*" %>
<%@ page import="xml.*" %>
<%@ page import="util.*" %>
<%@ page import="java.io.*" %>
<%@ page import="java.util.*" %>
<%@ include file="header.jsp" %>
<%@ include file="forum_menu.jsp" %>
<%
  int priv = forum.getCurrentPrivilege();
  if (priv < Privilege.WRITE) {
    String j_uri = request.getRequestURI();
    if (request.getQueryString() != null)
      j_uri += "?" + request.getQueryString();
    response.sendRedirect("/login.jsp?j_uri=" + response.encodeURL(j_uri));
  }

  String error = null;
  String subject = TextProcessor.normStr(request.getParameter("subject"));
  String text = TextProcessor.normStr(request.getParameter("text"));
  int forumId = topic.getId();
  int topicId = topic.getForum().getId();
  if (request.getParameter("action") == null) {
    subject = topic.getSubject();
    text = topic.getText();
    text = TextProcessor.postProcess(text);
  }
  if (session.getAttribute("fileRemover") == null)
    session.setAttribute("fileRemover", new FileRemover());
  if ("attachFile".equals(request.getParameter("action"))) {
    try {
      String fileName = TextProcessor.extractFileName(request.getParameter("file.filename"));
      Iterator iter = topic.getAttachments().iterator();
      boolean exist = false;
      while (iter.hasNext() && (!exist)) {
        Attachment a = (Attachment)iter.next();
        exist = a.getName().equals(fileName);
      }
      if (!exist) {
        File dir = new File(System.getProperty("app.path") + "files/" + topic.getId());
        dir.mkdirs();
        FileInputStream is = new FileInputStream(request.getParameter("file"));
        FileOutputStream os = new FileOutputStream(dir.getAbsolutePath() + "/" + fileName);
        byte[] buf = new byte[8192];
        for (int n = is.read(buf); n >= 0; n = is.read(buf)) {
          os.write(buf, 0, n);
        }
        is.close();
        os.close();
        EJBGetter.getAttachmentHome().create(topic, fileName);
      }
    } catch(Exception e) {
      e.printStackTrace();
    }
  } else if ("detachFile".equals(request.getParameter("action"))) {
    try {
      int fileNum = Integer.parseInt(request.getParameter("fileNum"));
      Attachment a = EJBGetter.getAttachmentHome().findByPrimaryKey(fileNum);
      a.remove();
    } catch (Exception ex) { }
  } else if ("updateTopic".equals(request.getParameter("action"))) {
    ForumCtrl ctrl = EJBGetter.getForumCtrlHome().create();
    try {
      Topic t = ctrl.updateTopic(request);
/*
      for (int i = 0; i < attachments.size(); i++) {
        File f;
        f = new File(System.getProperty("app.path") + "files/" + topic.getId());
        f.mkdirs();
        String fileName = (String)attachments.get(i);
        f = new File(System.getProperty("app.path") + "WEB-INF/tmp/" + session.getId() + "/" + fileName);
        f.renameTo(new File(System.getProperty("app.path") + "files/" + topic.getId() + "/" + fileName));
        Attachment att = EJBGetter.getAttachmentHome().create(topic, f.getName());
      }
*/
      response.sendRedirect("/forum_intopic.jsp?topicId=" + t.getId());
      return;
    } catch (ControlException ex) {
      error = ex.getMessage();
    } finally {
      ctrl.remove();
    }
  }
%>
<script language="JavaScript">
function insertIcon(icon) {
  document.topicForm.text.value += icon;
  document.topicForm.text.focus();
}
function attachFile() {
  document.topicForm.action.value = "attachFile";
  document.topicForm.submit();
  return true;
}
function detachFile(fileNum) {
  document.topicForm.action.value = "detachFile";
  document.topicForm.fileNum.value = fileNum;
  document.topicForm.submit();
  return true;
}
function updateTopic() {
  document.topicForm.action.value = "updateTopic";
  document.topicForm.submit();
  return true;
}
</script>
<table border="0" cellpadding="0" cellspacing="0" width="100%">
<% if (error != null) { %>
  <tr>
    <td class="wtext"><br><b>Error: </b><%=error%><br><br></td>
  </tr>
<% } %>
<% if ((topicId == -1) && (forumId == -1)) { %>
  <tr>
    <td class="wtext"><br><b>Error: </b>Topic does not exist<br><br></td>
  </tr>
<% } else { %>
  <form name="topicForm" method="post" enctype="multipart/form-data">
  <input type="hidden" name="action" value="">
  <input type="hidden" name="fileNum" value="">
  <input type="hidden" name="topicId" value="<%=topicId%>">
  <input type="hidden" name="forumId" value="<%=forumId%>">
  <tr>
    <td>
      <b>Subject:</b><br>
      <input type="text" name="subject" maxlength="100" style="width:100%" value="<%=subject%>">
    </td>
  </tr>
<%
  if (!topic.getAttachments().isEmpty()) {
%>
  <tr><td>
    <br><b>Attachments:</b>
    <table border="0" cellpadding="0" cellspacing="0">
<%
  Iterator iter = topic.getAttachments().iterator();
  while (iter.hasNext()) {
    Attachment a = (Attachment)iter.next();
    out.print("<tr><td>");
    out.print(a.getName());
    out.print("</td><td><img src='/img/sp.gif' width='10' height='1'></td><td>");
    out.print("<input type='button' class='btn' value='Delete' onclick='javascript:detachFile(" + a.getId() + ");'>");
    out.println("</td></tr>");
  }
%>
    </table>
  </td></tr>
<%
  }
%>
  <tr>
    <td>
      <br><b>Text:</b><br>
      <textarea name="text" style="width:100%; height:300px; font-family: Courier,monospace; font-size:12px;"><%=text%></textarea>
    </td>
  </tr>
  <tr valign="bottom">
    <td valign="bottom" style="vertical-align:bottom;height:0px;">
    <a href="javascript:insertIcon(':)');"><img src="emoticons/smile.gif" border=0></a>
    <a href="javascript:insertIcon(':(');"><img src="emoticons/frown.gif" border=0></a>
    <a href="javascript:insertIcon('0]');"><img src="emoticons/alien.gif" border=0></a>
    <a href="javascript:insertIcon('8)');"><img src="emoticons/glasses.gif" border=0></a>
    <a href="javascript:insertIcon('8o');"><img src="emoticons/nerd.gif" border=0></a>
    <a href="javascript:insertIcon(':b');"><img src="emoticons/tongue.gif" border=0></a>
    <a href="javascript:insertIcon(':D');"><img src="emoticons/happy.gif" border=0></a>
    <a href="javascript:insertIcon(';)');"><img src="emoticons/wink.gif" border=0></a>
    <a href="javascript:insertIcon(':o');"><img src="emoticons/embarassed.gif" border=0></a>
    <img src="/img/sp.gif" height="5" width="50">
    <b>File:</b> <input type="file" name="file"> <input type="button" class="btn" value="Attach" onclick="javascript:attachFile();">
    <img src="/img/sp.gif" height="5" width="50">
    <input type="button" class="btn" onclick="javascript:updateTopic();" value="Submit">
<% if (topic != null) { %>
    <input type="button" class="btn" onclick="javascript:window.location.href='/forum_intopic.jsp?topicId=<%=topic.getId()%>';" value="Cancel">
<% } else { %>
    <input type="button" class="btn" onclick="javascript:window.location.href='/forum_topics.jsp?forumId=<%=forum.getId()%>';" value="Cancel">
<% } %>
    </td>
  </tr>
  </form>
  <tr>
    <td align="right">
    </td>
  </tr>
<script language="JavaScript">
  document.topicForm.subject.focus();
</script>
<% } %>
</table>
<%@ include file="footer.jsp" %>
