<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- make sure '<' is not printed as '&lt;' -->
  <xsl:output disable-output-escaping='true'/>
  <xsl:output method="html"/>
  <xsl:output indent="yes"/>

  <xsl:param name="page" select="1"/>
  <xsl:param name="topicsPerPage" select="20"/>

  <!-- copy input to output -->
  <xsl:template match='*|@*'>
    <xsl:copy>
      <xsl:apply-templates select='node()|@*'/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="forums">
    <table border="1" cellpadding="5" cellspacing="0" width="100%">
      <tr>
        <th>Forum name</th>
        <th>Last post</th>
        <th>Topics</th>
        <th>Messages</th>
      </tr>
    <xsl:for-each select="forum">
      <tr>
        <td height="17">
          <a href="forum_topics.jsp?forumId={@id}" class="bylink"><xsl:value-of select='@name'/></a><br/>
          <span class="small"><xsl:value-of select='@description'/></span>
        </td>
        <td align="center"><xsl:value-of select='@last-post'/></td>
        <td align="center"><xsl:value-of select='@topics'/></td>
        <td align="center"><xsl:value-of select='@messages'/></td>
      </tr>
    </xsl:for-each>
    </table>
  </xsl:template>

  <xsl:template match="thread-topic">
    <xsl:param name="indent"/>
    <tr>
      <td>
        <xsl:choose>
          <xsl:when test="@status='new'">
            <img src="img/f_norm.gif" border="0" height="12" width="18"/>
          </xsl:when>
          <xsl:when test="@status='closed'">
            <img src="img/f_closed.gif" border="0" height="12" width="18"/>
          </xsl:when>
          <xsl:otherwise>
            <img src="img/f_norm_no.gif" border="0" height="12" width="18"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <div style="margin-left:{$indent}px; text-align:left;">
        <xsl:choose>
          <xsl:when test="@current='true'">
            <b><xsl:value-of select='@subject'/></b>
          </xsl:when>
          <xsl:otherwise>
            <a href="forum_intopic.jsp?topicId={@id}" class="bylink"><xsl:value-of select='@subject'/></a>
          </xsl:otherwise>
        </xsl:choose>
        </div>
      </td>
      <td><xsl:value-of select='@author'/></td>
      <td><xsl:value-of select='@posted'/></td>
    </tr>
    <xsl:apply-templates select='thread-topic'>
      <xsl:with-param name='indent' select='$indent + 10'/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="thread">
    <table border="1" cellpadding="5" cellspacing="0" width="100%">
    <tr>
      <th width="18"><br/></th>
      <th align="center">Subject</th>
      <th width="150" align="center">Author</th>
      <th width="150" align="center">Posted</th>
    </tr>
    <xsl:apply-templates select="thread-topic">
      <xsl:with-param name='indent' select='5'/>
    </xsl:apply-templates>
    </table>
  </xsl:template>

  <xsl:template match="topic">
    <table border="1" cellpadding="5" cellspacing="0" width="100%">
    <!--table border="1" cellpadding="3" cellspacing="0" width="800"-->
      <tr>
        <th width="70">Author:</th>
        <td width="100%"><xsl:value-of select='@author'/></td>
      </tr>
      <tr>
        <th width="70">Posted:</th>
        <td width="100%"><xsl:value-of select='@posted'/></td>
      </tr>
      <tr>
        <th width="70">Viewed:</th>
        <td width="100%"><xsl:value-of select='@viewed'/> times</td>
      </tr>
      <tr>
        <th width="70">Subject:</th>
        <td width="100%"><xsl:value-of select='@subject'/></td>
      </tr>
      <tr>
        <td colspan="2" width="100%" style="font-size:12px; font-family: 'Courier New',monospace;"><div style="font-family: Courier,monospace; font-size: 12px;"><xsl:apply-templates/></div></td>
      </tr>
      <xsl:if test="count(/topic/attachments/file) &gt; 0">
      <tr><td colspan="2">
        <xsl:for-each select="/topic/attachments/file">
          <a href="{@url}" target="_blank"><img src="/img/file.gif" border="0"/> <xsl:value-of select="@name"/></a> (<xsl:value-of select="@size"/>)<img src="/img/sp.gif" height="5" width="15"/>
        </xsl:for-each>
      </td></tr>
      </xsl:if>
    </table>
    <br/>
  </xsl:template>

  <xsl:template name="paginator">
    <table><tr><td class="wtext">Page:</td>
    <xsl:for-each select="/topics/topic">
      <xsl:if test="(position() - 1) mod $topicsPerPage = 0">
        <xsl:variable name="n" select="((position() - 1) div $topicsPerPage) + 1"/>
        <td class="wtext">
        <xsl:choose>
          <xsl:when test="$n = $page">
            <b><xsl:value-of select="$n"/></b>
          </xsl:when>
          <xsl:otherwise>
            <a href="javascript:gotoPage({$n})"><xsl:value-of select="$n"/></a>
          </xsl:otherwise>
        </xsl:choose>
        </td>
      </xsl:if>
    </xsl:for-each>
    </tr></table>
  </xsl:template>

  <xsl:template match="topics">
    <xsl:variable name="cnt" select="count(topic)" />
    <xsl:if test="$cnt &gt; $topicsPerPage">
      <form name="paginatorForm" method="get" style="position:absolute;"> 
      <xsl:for-each select="pgn:parameter">
        <input type="hidden" name="{@name}" value="{@value}"/>
      </xsl:for-each>
      </form>
      <script>
        function gotoPage(num) {
          document.paginatorForm.page.value = num;
          document.paginatorForm.submit();
        }
      </script>
      <xsl:call-template name="paginator"/>
    </xsl:if>
    <table border="1" cellpadding="3" cellspacing="0" width="100%">
    <tr>
      <th width="18"><img src="img/sp.gif" width="18" height="16"/></th>
      <th width="100%">Subject</th>
      <th>Info</th>
      <th>Replies</th>
      <th>Viewed</th>
    </tr>
    <xsl:variable name="firstTopic" select="($page - 1) * $topicsPerPage + 1" />
    <xsl:variable name="lastTopic" select="($page - 1) * $topicsPerPage + $topicsPerPage" />
    <xsl:for-each select="topic[(position() &gt;= $firstTopic) and ((position() &lt;= $lastTopic))]">
      <tr>
        <xsl:if test="position() mod 2 = 0">
          <xsl:attribute name="bgcolor">#F9F9F9</xsl:attribute>
        </xsl:if>
        <td width="18" valign="middle">
          <xsl:choose>
            <xsl:when test="@status='new'">
              <img src="img/f_norm.gif" border="0" height="12" width="18"/>
            </xsl:when>
            <xsl:when test="@status='closed'">
              <img src="img/f_closed.gif" border="0" height="12" width="18"/>
            </xsl:when>
            <xsl:otherwise>
              <img src="img/f_norm_no.gif" border="0" height="12" width="18"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td width="100%"><a href="forum_intopic.jsp?topicId={@id}"><xsl:value-of select='@subject'/></a></td>
        <td nowrap="true">
          Created: <xsl:value-of select='@posted'/> by <xsl:value-of select='@author'/>
          <xsl:if test="@last-reply-date != ''">
            <br/>Last post: <xsl:value-of select='@last-reply-date'/> by <xsl:value-of select='@last-reply-author'/>
          </xsl:if>
        </td>
        <td align="center"><xsl:value-of select='@messages'/></td>
        <td align="center"><xsl:value-of select='@viewed'/></td>
      </tr>
    </xsl:for-each>
    </table>
    <xsl:if test="$cnt &gt; $topicsPerPage">
      <xsl:call-template name="paginator"/>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
