package util.template;

import java.io.*;
import java.util.*;

public class Template {

  private static String BR_LEFT = "<$";
  private static String BR_RIGHT = "$>";
  private Vector matcherVector = new Vector();

  private class SystemPropertyMatcher extends AbstractMatcher implements Matcher {

    protected String getPrefix() {
      return "system.property.";
    }

    public String getValue(String postfix) {
      return System.getProperty(postfix);
    }

  }

  public Template() {
    addMatcher(new SystemPropertyMatcher());
  }

  public Template addMatcher(Matcher matcher) {
    matcherVector.add(matcher);
    return this;
  }

  private Matcher findMatcher(String str) throws TemplateException {
    for (int i = 0; i < matcherVector.size(); i++) {
      Matcher mtc = (Matcher)matcherVector.get(i);
      if (mtc.check(str))
        return mtc;
    }
    throw new TemplateException("could not match item '" + str +"'");
  }

  public String parse(File file) throws TemplateException, IOException {
    Reader reader = new FileReader(file);
    char[] charBuf = new char[(int)file.length()];
    reader.read(charBuf);
    StringBuffer strBuf = new StringBuffer();
    strBuf.append(charBuf);
    return parse(strBuf);
  }

  public String parse(String str) throws TemplateException {
    return parse(new StringBuffer(str));
  }

  public String parse(StringBuffer buf) throws TemplateException {
    int lIdx = 0;
    while ((lIdx = buf.indexOf(BR_LEFT, lIdx)) > 0) {
      int rIdx = buf.indexOf(BR_RIGHT, lIdx);
      if (rIdx == -1) 
        throw new TemplateException();
      String s = buf.substring(lIdx + BR_LEFT.length(), rIdx);
      s = findMatcher(s).match(s);
      buf.replace(lIdx, rIdx + BR_RIGHT.length(), s);
    }
    return buf.toString();
  }

}
