package util;

import java.text.*;
import java.util.*;

public class Format {

  private static java.text.Format dateFmt;
  private static java.text.Format dateTimeFmt;
  private static java.text.Format timeFmt;

  private static final String NULL_DATE = "[unknown]";

  public static String date(Date date) {
    if (date == null)
      return NULL_DATE;
    else
      return dateFmt.format(date);
  }

  public static String dateTime(Date date) {
    if (date == null)
      return NULL_DATE;
    else
      return dateTimeFmt.format(date);
  }

  public static String time(Date date) {
    if (date == null)
      return NULL_DATE;
    else
      return timeFmt.format(date);
  }

  public static String fileSize(long size) {
    if (size >= (500 * 1024)) {
      return new DecimalFormat("#.##MB").format(size / 1048576.0f);
    } else {
      return new DecimalFormat("#.##KB").format(size / 1024.0f);
    }
  }

  static {
    Locale.setDefault(Locale.US);
    dateFmt = new SimpleDateFormat("MMM d, yyyy");
    dateTimeFmt = new SimpleDateFormat("MMM d, yyyy 'at' h:mm aa");
    timeFmt = new SimpleDateFormat("h:mm:ss aa");
  }

}
