package servlet;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public final class Load extends HttpServlet {

  public void init(ServletConfig servletconfig) throws ServletException {
    super.init(servletconfig);
    Properties props = System.getProperties();
    Enumeration namesEnum = servletconfig.getInitParameterNames();
    while (namesEnum.hasMoreElements()) {
      String name = (String)namesEnum.nextElement();
      String param = servletconfig.getInitParameter(name);
      props.setProperty(name, param);
    }
    props.setProperty("app.path", getServletContext().getRealPath("/"));
    System.setProperties(props);
  } 
  
}
