package servlet;

import ejb.*;
import security.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;
import javax.ejb.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.caucho.server.http.*;

public class FileServlet extends com.caucho.server.http.FileServlet {

  public void service(ServletRequest request, ServletResponse response)  throws ServletException, IOException {

    int topicId = -1;
    HttpServletRequest req = (HttpServletRequest)request;
    HttpServletResponse resp = (HttpServletResponse)response;

    Pattern p = Pattern.compile("^/([0-9]+)/.*$");
    Matcher m = p.matcher(req.getPathInfo());
    if (m.matches()) {
      try {
        topicId = Integer.parseInt(m.group(1));
      } catch (Exception ex) { }
    }
    Topic topic = null;
    try {
      topic = EJBGetter.getTopicHome().findByPrimaryKey(topicId);
    } catch (FinderException ex) {}

    if (topic == null) {
      resp.sendError(HttpServletResponse.SC_NOT_FOUND);
      return;
    }
    int priv = topic.getForum().getCurrentPrivilege();
    if (priv < Privilege.READ) {
      resp.sendError(HttpServletResponse.SC_FORBIDDEN);
      return;
    }
    resp.setContentType("application/octet-stream");
    super.service(request, response);

  }

}