package security;

public class Privilege {

  public static final int NONE = 0;
  public static final int READ = 1;
  public static final int WRITE = 2;
  public static final int MODERATE = 3;
  public static final int ADMINISTRATE = 100;

  private Privilege() {} //singleton class

  public static String getNameById(int id) {
    if (id == NONE)
      return "NONE";
    else if (id == READ)
      return "READ";
    else if (id == WRITE)
      return "WRITE";
    else if (id == MODERATE)
      return "MODERATE";
    else if (id == ADMINISTRATE)
      return "ADMINISTRATE";
    else
      return null;
  }

  public static String[] getNameArray() {
    return new String[]{"NONE", "READ", "WRITE", "MODERATE", "ADMINISTRATE"};
  }

  public static int[] getIdArray() {
    return new int[]{NONE, READ, WRITE, MODERATE, ADMINISTRATE};
  }

}