package security;

import java.util.*;
import java.security.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.caucho.http.security.*;
import ejb.*;

public class Authenticator extends AbstractAuthenticator {

  public static final String ROLE_ADMIN = "admin";
  public static final String ROLE_USER = "user";

  protected Principal loginImpl(HttpServletRequest request, HttpServletResponse response,
                                ServletContext application, String name, String password) throws ServletException {
    try {
      User user = EJBGetter.getUserHome().findByName(name);
      if (password.equals(user.getPassword())) {
        user.setPrevLogin(user.getCurrLogin());
        user.setCurrLogin(new Date());
        user.setPrevAddress(user.getCurrAddress());
        user.setCurrAddress(request.getRemoteAddr());
        Cookie nameCookie = new Cookie("name", name);
        nameCookie.setMaxAge(2592000); // 30 days
        response.addCookie(nameCookie);
        return user;
      }
    } catch (Exception ex) {}
    return null;
  }
  
  public boolean isUserInRole(HttpServletRequest request, HttpServletResponse response,
                              ServletContext application, Principal user, String role) throws ServletException {

    if (user != null) {
      User u = (User)user;
      if (u.getGlobalPrivilege() >= Privilege.ADMINISTRATE)
        return true;
      else if (role.equalsIgnoreCase(ROLE_USER))
        return true;
      else
        return false;
    }
    return false;
  }

}