package ejb;

import javax.ejb.*;
import javax.naming.*;
import java.util.*;
import com.caucho.ejb.*;
import com.caucho.http.security.*;

public abstract class UserForumPrivilegeBean extends AbstractEntityBean {

  public abstract User getUser();
  public abstract void setUser(User value);

  public abstract Forum getForum();
  public abstract void setForum(Forum value);

  public abstract int getPrivilege();
  public abstract void setPrivilege(int value);

  public UserForumPrivilegePK ejbCreate(User user, Forum forum, int privilege) throws CreateException {
    try {
      UserForumPrivilegeHome home = (UserForumPrivilegeHome)getEntityContext().getEJBLocalHome();
      if (home.findByPrimaryKey(new UserForumPrivilegePK(user, forum)) != null)
        throw new CreateException("user's privilege for specified forum already assigned.");
    } catch (FinderException e) { }

    setUser(user);
    setForum(forum);
    setPrivilege(privilege);
    return null;
  }

  public void ejbPostCreate(User user, Forum forum, int privilege) { }

  public void ejbRemove() throws RemoveException { }

  public boolean equals(Object obj) {
    try {
      User user = ((UserForumPrivilege)obj).getUser();
      Forum forum = ((UserForumPrivilege)obj).getForum();
      return (getUser().equals(user) && getForum().equals(forum));
    } catch (Exception ex) {
      return false;
    }
  }

  public String toString() {
    return "[User=" + getUser() + " Forum=" + getForum() + " Privilege=" + getPrivilege() +"]";
  }
}
