package ejb;

import util.*;
import model.*;
import java.io.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.caucho.ejb.*;
import javax.servlet.http.*;

public class UserCtrlBean extends AbstractSessionBean {

  public void ejbCreate() throws CreateException { }

  public User registerUser(UserModel user) throws ControlException {

    User u = null;
    if (user.name.length() == 0)
      throw new UserCtrlException("name required");
    if (user.password.length() == 0)
      throw new UserCtrlException("password required");
    if (user.passwordConfirm.length() == 0)
      throw new UserCtrlException("password confirmation required");
    if (!user.password.equals(user.passwordConfirm))
      throw new UserCtrlException("incorrect password confirmation");
    if (user.email.length() == 0)
      throw new UserCtrlException("email required");
    if ((user.email.indexOf('@') < 0) || (user.email.indexOf('.') < 0))
      throw new UserCtrlException("invalid email format");
    try {
      u = EJBGetter.getUserHome().create(user.name, user.password, user.fullName, user.email);
    } catch(CreateException ex) {
      throw new UserCtrlException(ex.getMessage());
    }

    try {
      MailSender mail = EJBGetter.getMailSenderHome().create();
      StringTokenizer st = new StringTokenizer(System.getProperty("forum.notify"), ";,", false);
      mail.addTo("paul@i-vortex.com");
      mail.addTo("loop70@sms.beemail.ru");
      mail.setFrom(System.getProperty("mail.support"));
      mail.setSubject("New user registered");
      StringBuffer body = new StringBuffer();
      body.append("New user registered\n");
      body.append("Name: " + u.getName() + " (" + u.getFullNameExt() + ")\n");
      body.append(System.getProperty("site.url") + "admin/editUser.jsp?userId=" + u.getId());
      mail.setBodyText(body.toString());
      mail.send();
      mail.remove();
    } catch (Throwable ex) {
      ex.printStackTrace();
    }
    return u;
  }

  public User updateUser(UserModel user) throws EJBException {
    return null;
  }

  public void removeUser(User user) throws EJBException {
    try {
      User dead = getDead();
      Iterator iter = user.getTopics().iterator();
      while (iter.hasNext()) {
        Topic t = (Topic)iter.next();
        System.out.println("user.remove topic: " + t.toString());
        t.setUser(dead);
      }
      user.remove();
    } catch (Exception ex) {
      System.out.println("user.remove FinderException: " + ex.getMessage());
    }
  }

  public User getAnonymous() throws UserCtrlException {
    try {
      return EJBGetter.getUserHome().findByName(User.ANONYMOUS_LOGIN);
    } catch(FinderException ex) {
      throw new UserCtrlException("could not find Anonymous user", ex);
    }
  }

  public User getDead() throws UserCtrlException {
    try {
      return EJBGetter.getUserHome().findByName(User.DEAD_LOGIN);
    } catch(FinderException ex) {
      throw new UserCtrlException(ex.getMessage());
    }
  }

  public User getCurrent() throws UserCtrlException {
    User user = (User)getSessionContext().getCallerPrincipal();
    if (user == null) {
      user = getAnonymous();
    }
    return user;
  }


}
