package ejb;

import security.*;
import javax.ejb.*;
import javax.naming.*;
import java.util.*;
import com.caucho.ejb.*;
import com.caucho.http.security.*;

public abstract class UserBean extends AbstractEntityBean {


  public abstract int getId();

  public abstract String getName();
  public abstract void setName(String name);

  public abstract String getPassword();
  public abstract void setPassword(String password);

  public abstract String getFullName();
  public abstract void setFullName(String name);

  public abstract String getEmail();
  public abstract void setEmail(String email);

  public abstract Date getRegistered();
  public abstract void setRegistered(Date registered);

  public abstract String getPrevAddress();
  public abstract void setPrevAddress(String value);

  public abstract Date getPrevLogin();
  public abstract void setPrevLogin(Date value);

  public abstract String getCurrAddress();
  public abstract void setCurrAddress(String value);

  public abstract Date getCurrLogin();
  public abstract void setCurrLogin(Date value);

  public abstract int getGlobalPrivilege();
  public abstract void setGlobalPrivilege(int value);

  public abstract boolean getNotify();
  public abstract void setNotify(boolean value);

  public abstract Collection getTopics();

  public int ejbCreate(String name, String password, String fullName, String email) throws CreateException {
    try {
      UserHome home = (UserHome)getEntityContext().getEJBLocalHome();
      if (home.findByName(name) != null)
        throw new CreateException("user " + name + " already exists.");
    } catch (FinderException e) { }

    setName(name);
    setPassword(password);
    setFullName(fullName);
    setEmail(email);
    setRegistered(new Date());
    setCurrAddress("[unknown]");
    setPrevAddress("[unknown]");
    setGlobalPrivilege(Privilege.NONE);
    setNotify(true);
    return 0;
  }

  public void ejbPostCreate(String name, String password, String fullName, String email) { }

  public void ejbRemove() throws RemoveException { }

  public String getFullNameExt() {
    return (getFullName().length() == 0) ? getName() : getFullName();
  }
  
  public boolean isAnonymous() {
    return User.ANONYMOUS_LOGIN.equals(getName());
  }

  public boolean isAdmin() {
    return getGlobalPrivilege() >= Privilege.ADMINISTRATE;
  }

  public boolean equals(Object obj) {
    if ((obj instanceof User) && (obj != null))
      return getId() == ((User)obj).getId();
    else
      return false;
  }

  public String toString() {
    return "[User id=" + getId() + " Name: \"" + getName() + "\" Email: " + getEmail() +"]";
  }
}
