package ejb;

import javax.ejb.*;
import javax.naming.*;
import java.util.*;
import java.security.*;

public interface User extends EJBLocalObject, Principal {

  public static final int ADMIN_ID = 1;
  public static final int ANONYMOUS_ID = 2;
  public static final int DEAD_ID = 3;

  public static final String ANONYMOUS_LOGIN = "anonymous";
  public static final String ADMIN_LOGIN = "admin";
  public static final String DEAD_LOGIN = "dead";

  public int getId();

  public String getName();
  public void setName(String name);

  public String getPassword();
  public void setPassword(String password);

  public String getFullName();
  public String getFullNameExt();
  public void setFullName(String fullName);

  public String getEmail();
  public void setEmail(String email);

  public Date getRegistered();
  public void setRegistered(Date registered);

  public String getPrevAddress();
  public void setPrevAddress(String value);

  public Date getPrevLogin();
  public void setPrevLogin(Date value);

  public String getCurrAddress();
  public void setCurrAddress(String value);

  public Date getCurrLogin();
  public void setCurrLogin(Date value);

  public int getGlobalPrivilege();
  public void setGlobalPrivilege(int value);

  public boolean getNotify();
  public void setNotify(boolean value);

  public Collection getTopics();

  public boolean isAnonymous();

  public boolean isAdmin();

  public boolean equals(Object obj);

  public String toString();

}
