package ejb;

import javax.ejb.*;
import javax.naming.*;
import java.util.*;
import com.caucho.ejb.*;

public abstract class TopicBean extends AbstractEntityBean {

  public abstract int getId();

  public abstract Topic getParent();
  public abstract void setParent(Topic topic);

  public abstract Forum getForum();
  public abstract void setForum(Forum forum);

  public abstract User getUser();
  public abstract void setUser(User user);

  public abstract String getSubject();
  public abstract void setSubject(String subject);

  public abstract String getText();
  public abstract void setText(String text);

  public abstract Date getPosted();
  public abstract void setPosted(Date posted);

  public abstract int getViewed();
  public abstract void setViewed(int viewed);

  public abstract boolean getActive();
  public abstract void setActive(boolean active);

  public abstract Collection getChildren();

  public abstract Collection getAttachments();

  public boolean isEmptyStr(String str) {
    return ((str == null) || (str.trim().length() == 0));
  }

  public int ejbCreate(Forum forum, User user, String subject, String text) throws CreateException {
    if (isEmptyStr(subject) || isEmptyStr(text))
      throw new CreateException("Subject and topic text required");
    Date posted = new Date();
    forum.setLastPost(posted);
    setParent(null);
    setForum(forum);
    setUser(user);
    setSubject(subject);
    setText(text);
    setPosted(posted);
    setViewed(0);
    setActive(true);
    return 0;
  }

  public int ejbCreate(Topic parent, User user, String subject, String text) throws CreateException {
    if (isEmptyStr(subject) || isEmptyStr(text))
      throw new CreateException("Subject and topic text required");
    Date posted = new Date();
    parent.getForum().setLastPost(posted);
    setParent(parent);
    setForum(parent.getForum());
    setUser(user);
    setSubject(subject);
    setText(text);
    setPosted(posted);
    setViewed(0);
    setActive(true);
    return 0;
  }

  public void ejbPostCreate(Forum forum, User user, String subject, String text) { }

  public void ejbPostCreate(Topic parent, User user, String subject, String text) { }

  public void ejbRemove() throws RemoveException {
    //TopicHome home = (TopicHome)getEntityContext().getEJBLocalHome();
    Iterator iter = getChildren().iterator();
    while (iter.hasNext()) {
      ((Topic)iter.next()).remove();
    }

    iter = getAttachments().iterator();
    while (iter.hasNext()) {
      ((Attachment)iter.next()).remove();
    }

  }

  public void ejbHomeCloseThread(Topic topic) throws FinderException {
    topic.setActive(false);
    Iterator iter = topic.getChildren().iterator();
    while (iter.hasNext()) {
      ejbHomeCloseThread((Topic)iter.next());
    }    
  }

  public void ejbHomeOpenThread(Topic topic) throws FinderException {
    topic.setActive(true);
    Iterator iter = topic.getChildren().iterator();
    while (iter.hasNext()) {
      ejbHomeOpenThread((Topic)iter.next());
    }    
  }

  public int getSubtopicsCount() {
    Collection col = getChildren();
    int result = col.size();
    Iterator iter = col.iterator();
    while (iter.hasNext()) {
      result += ((Topic)iter.next()).getSubtopicsCount();
    }
    return result;
  }

  public Topic getLastReply() {
    Topic result = (Topic)getEntityContext().getEJBLocalObject();
    Iterator iter = getChildren().iterator();
    while (iter.hasNext()) {
      Topic lastReply = ((Topic)iter.next()).getLastReply();
      if (result.getPosted().getTime() < lastReply.getPosted().getTime())
        result = lastReply;
    }
    return result;
  }

  public Topic getRoot() {
    Topic topic = (Topic)getEntityContext().getEJBLocalObject();
    while (topic.getParent() != null) {
      topic = topic.getParent();
    }
    return topic;
  }

  public void incViewed() {
    setViewed(getViewed() + 1);
  }

  public boolean equals(Object obj) {
    if ((obj instanceof Topic) && (obj != null))
      return getId() == ((Topic)obj).getId();
    else
      return false;
  }

  public String toString() {
    return "[Id:" + getId() + " Subject:" + getSubject() + "]";
  }
}
