package ejb;

import util.*;
import util.template.*;
import java.lang.reflect.*;
import java.io.*;
import java.util.*;
import javax.ejb.*;
import com.caucho.ejb.*;
import javax.servlet.http.*;

public class PasswordReminderCtrlBean extends AbstractSessionBean implements Matcher {

  public String name;
  public String password;
  public String fullName;
  public String email;

  public void ejbCreate() { }

  public void sendPassword(HttpServletRequest request) throws ControlException {

    name = TextProcessor.normStr(request.getParameter("name"));
    if ("".equals(name))
      throw new ControlException("Login name required");

    User user = null;
    try {
      user = EJBGetter.getUserHome().findByName(name);
    } catch (FinderException ex) {
      throw new ControlException("User with the specified login name does not exist");
    }

    if (user == null) 
      throw new ControlException("User with the specified login name does not exist");

    email = user.getEmail();
    if ((email == null) || (email.length() == 0))
      throw new ControlException("Profile with this login name does not contain email address");

    password = user.getPassword();
    fullName = user.getFullNameExt();

    try {
      Template t = new Template();
      t.addMatcher(this);
      String text = t.parse(new File(System.getProperty("app.path") + "templates/reminder.template"));
      MailSender mail = EJBGetter.getMailSenderHome().create();
      try {
        mail.sendText(System.getProperty("mail.support"), email, "Password reminder", text);
      } finally {
        mail.remove();
      }
    } catch (Exception ex) {
      System.out.println("sendDownloadEmail exception:" + ex.getMessage());
    }

  }

  public boolean check(String value) {
    return value.startsWith("reminder.");
  }

  public String match(String value) {
    String name = value.substring(9);
    try {
      Field f = this.getClass().getField(name);
      return f.get(this).toString();
    } catch (Exception ex) {
      System.out.println(ex.toString());
      return "[UNKNOWN]";
    }
  }

}
