package ejb;

import java.io.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.caucho.vfs.*;
import com.caucho.ejb.*;

public class MailSenderBean extends AbstractSessionBean {

  private static final String TYPE_TEXT = "text/plain; charset=\"us-ascii\"";
  private static final String TYPE_HTML = "text/html; charset=\"us-ascii\"";

  private List to;
  private List cc;
  private List bcc;
  private String from;
  private String subject;
  private String contentType;
  private String body;

  private void checkAddres(String addr) throws MailSenderException {
    if ((addr == null) || (addr.trim().length() == 0))
      throw new MailSenderException("invalid address ");
  }

  private void initVars() {
    to = new ArrayList();
    cc = new ArrayList();
    bcc = new ArrayList();
    from = "";
    subject = "";
    contentType = TYPE_TEXT;
    body = "";
  }

  public void ejbCreate() {
    initVars();
  }

  public void setFrom(String addr) throws MailSenderException {
    checkAddres(addr);
    this.from = addr;
  }

  public void addTo(String addr) throws MailSenderException {
    checkAddres(addr);
    to.add(addr);
  }

  public void addCc(String addr) throws MailSenderException {
    checkAddres(addr);
    cc.add(addr);
  }

  public void addBcc(String addr) throws MailSenderException {
    checkAddres(addr);
    bcc.add(addr);
  }

  public void setSubject(String subject) {
    this.subject = subject;
  }

  public void setBodyText(String body) {
    contentType = TYPE_TEXT;
    this.body = body;
  }

  public void setBodyHtml(String body) {
    contentType = TYPE_HTML;
    this.body = body;
  }

  private String listToString(List lst, int offset) {
    StringBuffer sb = new StringBuffer();
    for (int i = offset; i < lst.size(); i++) {
      if (i > offset)
        sb.append(",");
      sb.append(lst.get(i).toString());
    }
    return sb.toString();
  }

  private String listToString(List lst) {
    return listToString(lst, 0);
  }

  public void send() throws MailSenderException {
    try {
      Path path = Vfs.lookup("mailto:" + to.get(0).toString());
      path.setAttribute("Sender", from);
      path.setAttribute("From", from);

      path.setAttribute("To", listToString(to, 1));
      path.setAttribute("Cc", listToString(cc));
      path.setAttribute("Bcc", listToString(bcc));

      path.setAttribute("Subject", subject);
      path.setAttribute("Content-Type", contentType);
      path.setAttribute("Importance", "High");
      path.setAttribute("X-Priority", "1 (Highest)");
      path.setAttribute("X-MSMail-Priority", "High");
      
      WriteStream stream = path.openWrite();
      stream.println(body);
      stream.close();
    } catch (Exception ex) {
      throw new MailSenderException("couldn't send mail", ex);
    } finally {
      initVars();
    }
  }

  public void sendText(String from, String to, String subject, String text) throws MailSenderException {
    setFrom(from);
    addTo(to);
    setSubject(subject);
    setBodyText(text);
    send();
  }

  public void sendHTML(String from, String to, String subject, String text) throws MailSenderException {
    setFrom(from);
    addTo(to);
    setSubject(subject);
    setBodyHtml(text);
    send();
  }

}
