package ejb;

import javax.ejb.*;
import javax.naming.*;
import com.caucho.ejb.*;

public interface MailSender extends EJBLocalObject {

  public void sendText(String from, String to, String subject, String text) throws MailSenderException;

  public void sendHTML(String from, String to, String subject, String text) throws MailSenderException;

  public void setFrom(String to) throws MailSenderException;
  public void addTo(String to) throws MailSenderException;
  public void addCc(String to) throws MailSenderException;
  public void addBcc(String bcc) throws MailSenderException;

  public void setSubject(String subject);
  public void setBodyText(String body);
  public void setBodyHtml(String body);

  public void send() throws MailSenderException;

}
