package ejb;

import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.caucho.util.ClassLoaderLocal;

public class EJBGetter {

  private Map homeMap;

  private static ClassLoaderLocal contextEJBGetter = new ClassLoaderLocal();

  private EJBGetter() {
    homeMap = new Hashtable();
  }

  private EJBLocalHome getHome(String ejbName) {
    EJBLocalHome result = null;
    if (! homeMap.containsKey(ejbName)) {
      try {
        Context ejb = (Context) new InitialContext().lookup("java:comp/env/cmp");
        result = (EJBLocalHome)ejb.lookup(ejbName);
      } catch (NamingException ex) {
        throw new Error(ex);
      }
      homeMap.put(ejbName, result);
    } else {
      result = (EJBLocalHome)homeMap.get(ejbName);
    }
    return result;
  }

  public static UserHome getUserHome() {
    return (UserHome)getEJBGetter().getHome("User");
  }

  public static UserForumPrivilegeHome getUserForumPrivilegeHome() {
    return (UserForumPrivilegeHome)getEJBGetter().getHome("UserForumPrivilege");
  }

  public static ForumHome getForumHome() {
    return (ForumHome)getEJBGetter().getHome("Forum");
  }

  public static TopicHome getTopicHome() {
    return (TopicHome)getEJBGetter().getHome("Topic");
  }

  public static AttachmentHome getAttachmentHome() {
    return (AttachmentHome)getEJBGetter().getHome("Attachment");
  }

  public static ForumCtrlHome getForumCtrlHome() {
    return (ForumCtrlHome)getEJBGetter().getHome("ForumCtrl");
  }

  public static MailSenderHome getMailSenderHome() {
    return (MailSenderHome)getEJBGetter().getHome("MailSender");
  }

  public static UserCtrlHome getUserCtrlHome() {
    return (UserCtrlHome)getEJBGetter().getHome("UserCtrl");
  }

  public static PasswordReminderCtrlHome getPasswordReminderCtrlHome() {
    return (PasswordReminderCtrlHome)getEJBGetter().getHome("PasswordReminderCtrl");
  }

  private static EJBGetter getEJBGetter() {
    EJBGetter getter = (EJBGetter)contextEJBGetter.get();
    if (getter == null) {
      getter = new EJBGetter();
      contextEJBGetter.set(getter);
    }
    return getter;
  }

}
