package ejb;

import java.io.*;
import javax.ejb.*;
import javax.naming.*;
import java.util.*;
import com.caucho.ejb.*;

public abstract class AttachmentBean extends AbstractEntityBean {

  private File file = null;

  public abstract int getId();

  public abstract Topic getTopic();
  public abstract void setTopic(Topic value);

  public abstract String getName();
  public abstract void setName(String name);


  public int ejbCreate(Topic topic, String name) throws CreateException {
    setTopic(topic);
    setName(name);
    return 0;
  }

  public void ejbPostCreate(Topic topic, String name) { }


  public void ejbRemove() throws RemoveException {
    File f = getFile();
    f.delete();
    new File(f.getParent()).delete();
  }

  public long getSize() {
    return getFile().length();
  }

  private File getFile() {
    if (file == null) {
      file = new File(System.getProperty("app.path") + "files/" + getTopic().getId() + "/" + getName());
    }
    return file;
  }

  public boolean equals(Object obj) {
    try {
      return getId() == ((Attachment)obj).getId();
    } catch (Exception ex) {
      return false;
    }
  }

  public String toString() {
    return "[Id:" + getId() + " Name:" + getName() + "]";
  }
}
