
use i_vortex;

set AUTOCOMMIT=0;

begin;

##### USER #####
drop table if exists user; 
create table user (
  id int not null auto_increment,
  name varchar(50) not null,
  password varchar(20) not null,
  full_name varchar(100) default '',
  email varchar(200) default '',
  registered datetime not null default 0,
  prev_address varchar(15) default '[unknown]',
  prev_login datetime,
  curr_address varchar(15) default '[unknown]',
  curr_login datetime,
  primary key (id),
  unique index idx_user_name(name)) type=InnoDB;


insert into user (name, password, full_name) values ('admin', '123123', 'admin');
insert into user (name, password, full_name) values ('anonymous', md5(now()), 'anonymous');
insert into user (name, password, full_name) values ('dead', md5(now()), 'removed user');
insert into user (name, password) values ('reserved04', md5(now()));
insert into user (name, password) values ('reserved05', md5(now()));
insert into user (name, password) values ('reserved06', md5(now()));
insert into user (name, password) values ('reserved07', md5(now()));
insert into user (name, password) values ('reserved08', md5(now()));
insert into user (name, password) values ('reserved09', md5(now()));
insert into user (name, password) values ('reserved10', md5(now()));
insert into user (name, password) values ('reserved11', md5(now()));
insert into user (name, password) values ('reserved12', md5(now()));
insert into user (name, password) values ('reserved13', md5(now()));
insert into user (name, password) values ('reserved14', md5(now()));
insert into user (name, password) values ('reserved15', md5(now()));
insert into user (name, password) values ('reserved16', md5(now()));
insert into user (name, password) values ('reserved17', md5(now()));
insert into user (name, password) values ('reserved18', md5(now()));
insert into user (name, password) values ('reserved19', md5(now()));
insert into user (name, password) values ('reserved20', md5(now()));
update user set full_name=name where name like 'reserved__';
update user set registered=now();

##### FORUM #####
drop table if exists forum; 
create table forum (
  id int not null auto_increment,
  name varchar(200) not null,
  description text default '',
  last_post datetime,
  active int(1) not null default 1,
  primary key (id),
  unique index idx_forum_name(name)) type=InnoDB;

insert into forum (name, description) values ('forum1', 'test forum number one');
insert into forum (name, description) values ('forum2', 'test forum number two');

##### TOPIC #####
drop table if exists topic; 
create table topic (
  id int not null auto_increment,
  parent int,
  forum int not null,
  user int not null,
  subject varchar(200) not null,
  text text default '',
  posted datetime,
  viewed int not null default 0,
  active int(1) not null default 1,
  primary key (id),
  index idx_topic_parent(parent),
  index idx_topic_forum(forum),
  index idx_topic_user(user),
  index idx_topic_forum_parent(forum, parent),
  constraint fk_topic_forum foreign key(forum) references forum(id),
  constraint fk_topic_user foreign key(`user`) references `user`(id)) type=InnoDB;


commit;
