<%@ page import="ejb.*" %>
<%@ page import="xml.*" %>
<%@ page import="util.*" %>
<%
  String error = null;
  String action = "createTopic";
  if (action.equals(request.getParameter("action"))) {
    ForumCtrl ctrl = EJBGetter.getForumCtrlHome().create();
    try {
      Topic topic = ctrl.createTopic(request);
      response.sendRedirect("/forum_intopic.jsp?topicId=" + topic.getId());
      return;
    } catch (ControlException ex) {
      error = ex.getMessage();
    } finally {
      ctrl.remove();
    }
  }
%>
<%@ include file="forum_objects.jsp" %>
<%
  String subject = TextProcessor.normStr(request.getParameter("subject"));
  String text = TextProcessor.normStr(request.getParameter("text"));
  int forumId = -1;
  int topicId = -1;
  if (topic != null) {
    topicId = topic.getId();
    forumId = topic.getForum().getId();
    if (text.length() == 0) {
      text = topic.getText();
      text = TextProcessor.postProcess(text);
      text = TextProcessor.reply(text);
      text = topic.getUser().getFullName() + " wrote:" + System.getProperty("line.separator") + text;
    }
    if (subject.length() == 0) {
      subject = "RE:" + topic.getSubject();
    }
  } else if (forum != null) {
    forumId = forum.getId();
  }
%>
<% String ct = "Forum"; %>
<%@ include file="header.jsp" %>
<script language="JavaScript">
function insertIcon(icon) {
  document.topicForm.text.value += icon;
  document.topicForm.text.focus();
}
</script>
<table border="0" cellpadding="0" cellspacing="0" width="509">
<% if (error != null) { %>
  <tr>
    <td class="wtext"><br><b>Error: </b><%=error%><br><br></td>
  </tr>
<% } %>
<% if ((topicId == -1) && (forumId == -1)) { %>
  <tr>
    <td class="wtext"><br><b>Error: </b>Topic does not exist<br><br></td>
  </tr>
<% } else { %>
  <form name="topicForm" method="post">
  <input type="hidden" name="action" value="<%=action%>">
  <input type="hidden" name="topicId" value="<%=topicId%>">
  <input type="hidden" name="forumId" value="<%=forumId%>">
  <tr>
    <td height="16" valign="top" class="btext">Subject:</td>
  </tr>
  <tr>
    <td height="26" valign="top" class="btext"><input type="text" name="subject" class="tf1" maxlength="100" style="width:100%" value="<%=subject%>"></td>
  </tr>
  <tr>
    <td height="16" valign="top" class="btext">Text</td>
  </tr>
  <tr>
    <td height="184" valign="top" class="btext"><textarea name="text" cols="50" rows="12" class="tf2" style="width:509px; height:300px"><%=text%></textarea></td>
  </tr>
  <tr>
    <td height="23" valign="top">
    <a href="javascript:insertIcon(':)');"><img src="emoticons/smile.gif" border=0></a>
    <a href="javascript:insertIcon(':(');"><img src="emoticons/frown.gif" border=0></a>
    <a href="javascript:insertIcon('0]');"><img src="emoticons/alien.gif" border=0></a>
    <a href="javascript:insertIcon('8)');"><img src="emoticons/glasses.gif" border=0></a>
    <a href="javascript:insertIcon('8o');"><img src="emoticons/nerd.gif" border=0></a>
    <a href="javascript:insertIcon(':b');"><img src="emoticons/tongue.gif" border=0></a>
    <a href="javascript:insertIcon(':D');"><img src="emoticons/happy.gif" border=0></a>
    <a href="javascript:insertIcon(';)');"><img src="emoticons/wink.gif" border=0></a>
    <a href="javascript:insertIcon(':o');"><img src="emoticons/embarassed.gif" border=0></a>
    </td>
  </tr>
  </form>
  <tr>
    <td height="1" background="img/h_dot.jpg"><img src="img/sp.gif" width="1" height="1"></td>
  </tr>
  <tr>
    <td><img src="img/sp.gif" width="1" height="6"></td>
  </tr>
  <tr>
    <td align="right">
      <input type="image" src="/btn/Submit.gif" onclick="javascript:document.topicForm.submit();" alt="Submit" title="Submit">
<% if (topic != null) { %>
      <input type="image" src="/btn/Cancel.gif" onclick="javascript:window.location.href='/forum_intopic.jsp?topicId=<%=topic.getId()%>';" alt="Cancel" title="Cancel">
<% } else { %>
      <input type="image" src="/btn/Cancel.gif" onclick="javascript:window.location.href='/forum_topics.jsp?forumId=<%=forum.getId()%>';" alt="Cancel" title="Cancel">
<% } %>
    </td>
  </tr>
<script language="JavaScript">
  document.topicForm.subject.focus();
</script>
<% } %>
</table>
<%@ include file="footer.jsp" %>
