<%@ page import="ejb.*" %>
<%@ page import="xml.*" %>
<%@ page import="util.*" %>
<%
  String error = null;
  BrainCtrl ctrl = EJBGetter.getBrainCtrlHome().create();
  Brain brain = null;
  try {
    int brainId = Integer.parseInt(request.getParameter("brainId"));
    brain = EJBGetter.getBrainHome().findByPrimaryKey(brainId);
  } catch (Exception ex) {
    response.sendRedirect("brain.jsp");
    return;
  }

  String action = TextProcessor.normStr(request.getParameter("action"));
  if (action.equals("updateBrain")) {
    try {
      brain = ctrl.updateBrain(request);
      response.sendRedirect("brain.jsp");
      return;
    } catch (Exception ex) {
      error = ex.getMessage();
    }
  }
%>
<%@ include file="header.jsp" %>
<%
  if (error != null) {
    out.println("<b>ERROR:</b><br>" + error + "<br><hr>");
  }
  String selector = XMLTransformer.transform("brainAdmin.xsl", ctrl.xmlSpecialtySelector(brain.getSpecialty()), request);
%>
<br>
<table border="1" cellpadding="0">
<form action="brain_edit.jsp" method="post" enctype="multipart/form-data">
<input type="hidden" name="action" value="updateBrain">
<input type="hidden" name="brainId" value="<%=brain.getId()%>">
<tr><td>Visible:<td><input type="checkbox" name="visible" <%=(brain.getVisible()) ? "checked" : ""%>>
<tr><td>Specialty:<td><select name="specialtyId"><%=selector%></select><input name="specialty" value="">
<tr><td>Name:<td><input name="name" style="width:100%" value="<%=brain.getName()%>">
<tr><td>File:<td><%=brain.getFile()%> <input type="file" name="file">
<tr><td>Author:<td><input name="author" style="width:100%" value="<%=brain.getAuthor()%>">
<tr><td>Description:<td><input name="description" style="width:100%" value="<%=brain.getDescription()%>">
<tr><td>Created:<td><%=Format.dateTime(brain.getCreated())%>
<tr><td>Updated:<td><%=Format.dateTime(brain.getUpdated())%>
<tr><td colspan="2" align="center"><input type="submit" value="Submit"> <input type="button" value="Cancel" onClick="javascript:window.location.href='brain.jsp'"></td>
</form>
</table>
</html>
<%
  ctrl.remove();
%>
