<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- make sure '<' is not printed as '&lt;' -->
  <xsl:output disable-output-escaping='true'/>
  <xsl:output method="html"/>
  <xsl:output indent="yes"/>

  <!-- copy input to output -->
  <xsl:template match='*|@*'>
    <xsl:copy>
      <xsl:apply-templates select='node()|@*'/>
    </xsl:copy>
  </xsl:template>

  <xsl:param name="page" select="1"/>
  <xsl:param name="itemsPerPage" select="50"/>

  <!-- copy input to output -->
  <xsl:template match='*|@*'>
    <xsl:copy>
      <xsl:apply-templates select='node()|@*'/>
    </xsl:copy>
  </xsl:template>

  <xsl:template name="paginator">
    <table><tr><td>Page:</td>
    <xsl:for-each select="subscriber">
      <xsl:if test="(position() - 1) mod $itemsPerPage = 0">
        <xsl:variable name="n" select="((position() - 1) div $itemsPerPage) + 1"/>
        <td>
        <xsl:choose>
          <xsl:when test="$n = $page">
            <b><xsl:value-of select="$n"/></b>
          </xsl:when>
          <xsl:otherwise>
            <a href="javascript:gotoPage({$n})"><xsl:value-of select="$n"/></a>
          </xsl:otherwise>
        </xsl:choose>
        </td>
      </xsl:if>
    </xsl:for-each>
    </tr></table>
  </xsl:template>

  <xsl:template match="subscribers-list">
    <xsl:variable name="cnt" select="count(subscriber)" />
    <xsl:if test="$cnt &gt; $itemsPerPage">
      <form name="paginatorForm" method="get" style="position:absolute;" action="/admin/subscribers.jsp">
      <input type="hidden" name="page" value="{@page}"/>
      </form>
      <script language="JavaScript">
        function gotoPage(num) {
          document.paginatorForm.page.value = num;
          document.paginatorForm.submit();
        }
      </script>
      <xsl:call-template name="paginator"/>
    </xsl:if>
    Total: <xsl:value-of select="count(subscriber)"/> Active: <xsl:value-of select="count(subscriber[@active = 'true'])"/>
    <table width="100%" border="1" cellpadding="5" cellspacing="0">
    <tr>
      <th bgcolor="#CCCCCC">id</th>
      <th bgcolor="#CCCCCC">email</th>
      <th bgcolor="#CCCCCC">subscribed</th>
      <th bgcolor="#CCCCCC">news sent</th>
      <th bgcolor="#CCCCCC">format</th>
      <th bgcolor="#CCCCCC">active</th>
      <th bgcolor="#CCCCCC"><br/></th>
    </tr>
    <xsl:variable name="firstItem" select="($page - 1) * $itemsPerPage + 1" />
    <xsl:variable name="lastItem" select="($page - 1) * $itemsPerPage + $itemsPerPage" />
    <form name="deleteForm" method="post">
    <input type="hidden" name="deleteId" value=""/>
    </form>
    <xsl:for-each select="subscriber[(position() &gt;= $firstItem) and ((position() &lt;= $lastItem))]">
      <tr valign="top">
        <td><xsl:value-of select='@id'/></td>
        <td><xsl:value-of select='@email'/></td>
        <td><xsl:value-of select='@subscribed'/></td>
        <td><xsl:value-of select='@noticed'/></td>
        <td>
        <xsl:choose>
          <xsl:when test="@format = 1">
            TEXT
          </xsl:when>
          <xsl:when test="@format = 2">
            HTML
          </xsl:when>
          <xsl:otherwise>
            UNKNOWN
          </xsl:otherwise>
        </xsl:choose>
        </td>
        <td><xsl:value-of select='@active'/></td>
        <td><input type="button" value="Delete" onclick="javascript:document.deleteForm.deleteId.value='{@id}';document.deleteForm.submit();"/></td>
      </tr>        
    </xsl:for-each>
    </table>
    <xsl:if test="$cnt &gt; $itemsPerPage">
      <xsl:call-template name="paginator"/>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
