<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- make sure '<' is not printed as '&lt;' -->
  <xsl:output disable-output-escaping='true'/>
  <xsl:output method="html"/>
  <xsl:output indent="yes"/>

  <xsl:param name="page" select="1"/>
  <xsl:param name="newsPerPage" select="10"/>

  <!-- copy input to output -->
  <xsl:template match='*|@*'>
    <xsl:copy>
      <xsl:apply-templates select='node()|@*'/>
    </xsl:copy>
  </xsl:template>

  <xsl:template name="paginator">
    <table><tr><td class="wtext">Page:</td>
    <xsl:for-each select="news">
      <xsl:if test="(position() - 1) mod $newsPerPage = 0">
        <xsl:variable name="n" select="((position() - 1) div $newsPerPage) + 1"/>
        <td class="wtext">
        <xsl:choose>
          <xsl:when test="$n = $page">
            <b><xsl:value-of select="$n"/></b>
          </xsl:when>
          <xsl:otherwise>
            <a class="bylink" href="javascript:gotoPage({$n})"><xsl:value-of select="$n"/></a>
          </xsl:otherwise>
        </xsl:choose>
        </td>
      </xsl:if>
    </xsl:for-each>
    </tr></table>
  </xsl:template>

  <xsl:template match="news-list">
    <script language="JavaScript"><![CDATA[
      ar_right = new Image();
      ar_right.src = "img/ar_right.gif";
      ar_down = new Image();
      ar_down.src = "img/ar_down.gif";
      function showNews(id) {
        obj = document.getElementById("news" + id);
        if (obj != null) {
          if (obj.innerHTML == "") {
            document.images["img_"+id].src = ar_down.src;
            obj.innerHTML = document.getElementById("news_src_" + id).innerHTML;
          } else {
            document.images["img_"+id].src = ar_right.src;
            obj.innerHTML = "";
          }
        }
      }
      function hintToggle() { hint("Click for toggle news"); return true; }
    ]]></script>
    <xsl:variable name="cnt" select="count(news)" />
    <xsl:if test="$cnt &gt; $newsPerPage">
      <form name="paginatorForm" method="get" style="position:absolute;" action="news.jsp">
      <xsl:for-each select="pgn:parameter">
        <input type="hidden" name="{@name}" value="{@value}"/>
      </xsl:for-each>
      </form>
      <script language="JavaScript">
        function gotoPage(num) {
          document.paginatorForm.page.value = num;
          document.paginatorForm.submit();
        }
      </script>
      <xsl:call-template name="paginator"/>
    </xsl:if>
    <table border="0" cellpadding="0" cellspacing="0" width="509">
    <xsl:variable name="firstTopic" select="($page - 1) * $newsPerPage + 1" />
    <xsl:variable name="lastTopic" select="($page - 1) * $newsPerPage + $newsPerPage" />
    <xsl:for-each select="news[(position() &gt;= $firstTopic) and ((position() &lt;= $lastTopic))]">
      <tr>
        <xsl:if test="position() mod 2 = 1">
          <xsl:attribute name="bgcolor">#ff7100</xsl:attribute>
        </xsl:if>
        <td width="509" height="5" colspan="2"><a name="{@id}"></a></td>
      </tr>
      <tr valign="top">
        <xsl:if test="position() mod 2 = 1">
          <xsl:attribute name="bgcolor">#ff7100</xsl:attribute>
        </xsl:if>
        <td width="9"><a href="javascript:showNews('{@id}');"><img border="0" id="img_{@id}" src="img/ar_right.gif" width="14" height="14"/></a></td>
        <td width="500"><div style="margin-left:10px;" class="wtext">
          <xsl:value-of select='@posted'/> - <a href="javascript:showNews('{@id}');" class="bylink" onmouseover="hintToggle();" onmouseout="nd();"><xsl:value-of select='@subject'/></a></div>
        </td>
      </tr>
      <tr>
        <xsl:if test="position() mod 2 = 1">
          <xsl:attribute name="bgcolor">#ff7100</xsl:attribute>
        </xsl:if>
        <td width="509" height="5" colspan="9" id="news{@id}"></td>
      </tr>
      <tr>
        <td height="1" colspan="9" bgcolor="#ffa000"><img src="img/sp.gif" width="1" height="1"/>
        <div id="news_src_{@id}" style="position:absolute; visibility:hidden;">
        <div class="wtext" style="text-align:justify; margin:10px 10px 10px 40px;"><xsl:apply-templates/></div>
        </div>
        </td>
      </tr>
    </xsl:for-each>
    </table>
    <xsl:if test="$cnt &gt; $newsPerPage">
      <xsl:call-template name="paginator"/>
    </xsl:if>
    <script language="JavaScript">
      id = window.location.hash.substring(1);
      if (id != "") 
        showNews(id);
    </script>

  </xsl:template>

</xsl:stylesheet>
