<!--
  $Log: newsAnnounce.xsl,v $
  Revision 1.7  2002/11/20 21:48:10  paul
  * 5 news instead of 3

  Revision 1.6  2002/11/20 21:05:44  paul
  without comment

  Revision 1.5  2002/11/19 17:16:35  paul
  + date of posting added before every news

  Revision 1.4  2002/11/19 17:13:26  paul
  * space between news changet from 25 to 10

  Revision 1.3  2002/11/19 17:09:52  paul
  file added

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- make sure '<' is not printed as '&lt;' -->
  <xsl:output disable-output-escaping='true'/>
  <xsl:output method="html"/>
  <xsl:output indent="yes"/>

  <!-- copy input to output -->
  <xsl:template match='*|@*'>
    <xsl:copy>
      <xsl:apply-templates select='node()|@*'/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="news-list">
    <xsl:variable name="cnt" select="count(news)" />
    <table border="0" cellpadding="0" cellspacing="0" width="556">
    <xsl:for-each select="news[position() &lt;= 5]">
      <tr>
        <td width="7" valign="top"><img src="img/i_pointer.jpg" width="7" height="7" vspace="3"/></td>
        <td width="10"><img src="img/sp.gif" width="10" height="1"/></td>
        <td width="539" class="wtext">
        <xsl:value-of select='@posted'/> - <xsl:value-of select='@subject'/>. <a href="news.jsp#{@id}" class="ylink">Read more...</a>
        </td>
      </tr>
      <tr>
        <td colspan="3"><img src="img/sp.gif" width="1" height="10"/></td>
      </tr>
    </xsl:for-each>
    </table>
  </xsl:template>

</xsl:stylesheet>
