<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- make sure '<' is not printed as '&lt;' -->
  <xsl:output disable-output-escaping='true'/>
  <xsl:output method="html"/>
  <xsl:output indent="yes"/>

  <!-- copy input to output -->
  <xsl:template match='*|@*'>
    <xsl:copy>
      <xsl:apply-templates select='node()|@*'/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="news-list">
    <table width="100%" border="1" cellpadding="5" cellspacing="0">
    <tr>
      <th bgcolor="#CCCCCC">posted</th>
      <th bgcolor="#CCCCCC" width="100%">subject</th>
    </tr>
    <xsl:for-each select="news">
      <tr valign="top">
        <td nowrap="1"><xsl:value-of select='@posted'/></td>
        <td>
          <a href="editNews.jsp?newsId={@id}"><xsl:value-of select='@subject'/></a>
        </td>
      </tr>        
    </xsl:for-each>
    </table>
  </xsl:template>

</xsl:stylesheet>
