<!--
  $Log: forum.xsl,v $
  Revision 1.3  2002/11/19 22:00:02  paul
  - function hint() moved out
  - old comments

  Revision 1.2  2002/11/18 22:54:40  paul
  + Log keyword added

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- make sure '<' is not printed as '&lt;' -->
  <xsl:output disable-output-escaping='true'/>
  <xsl:output method="html"/>
  <xsl:output indent="yes"/>

  <xsl:param name="page" select="1"/>
  <xsl:param name="topicsPerPage" select="20"/>

  <!-- copy input to output -->
  <xsl:template match='*|@*'>
    <xsl:copy>
      <xsl:apply-templates select='node()|@*'/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="forums">
    <script language="javascript">
      function hintClosed() { return hint('This forum is closed'); }
      function hintActive() { return hint('This forum is active'); }
    </script>
    <table border="0" cellpadding="0" cellspacing="0" width="509">
      <tr>
        <td width="249" background="img/bg_ftabtit.gif" class="btext" style="text-indent:1em;">Forum name</td>
        <td width="1" height="16"><img src="img/sp.gif" width="1" height="16"/></td>
        <td width="119" background="img/bg_ftabtit.gif" align="center" class="btext">Last post</td>
        <td width="1" height="16"><img src="img/sp.gif" width="1" height="16"/></td>
        <td width="61" background="img/bg_ftabtit.gif" align="center" class="btext">Topics</td>
        <td width="1" height="16"><img src="img/sp.gif" width="1" height="16"/></td>
        <td width="77" background="img/bg_ftabtit.gif" align="center" class="btext">Messages</td>
      </tr>
    <xsl:for-each select="forum">
      <tr>
        <td width="249" height="17" class="wtext">
          <a href="forum_topics.jsp?forumId={@id}" class="bylink"><xsl:value-of select='@name'/></a><br/>
          <xsl:value-of select='@description'/>
        </td>
        <td width="1" height="16"><img src="img/sp.gif" width="1" height="16"/></td>
        <td width="119" height="17" align="center" class="wtext"><xsl:value-of select='@last-post'/></td>
        <td width="1" height="16"><img src="img/sp.gif" width="1" height="16"/></td>
        <td width="61" height="17" align="center" class="wtext"><xsl:value-of select='@topics'/></td>
        <td width="1" height="16"><img src="img/sp.gif" width="1" height="16"/></td>
        <td width="77" height="17" align="center" class="wtext"><xsl:value-of select='@messages'/></td>
      </tr>
      <tr>
        <td height="1" colspan="99" bgcolor="#ffa000"><img src="img/sp.gif" width="1" height="1"/></td>
      </tr>
    </xsl:for-each>
    </table>
  </xsl:template>

  <xsl:template name="hint-script">
    <script language="javascript">
      function hintClosed() { return hint('This topic is closed'); }
      function hintActive() { return hint('This topic is active'); }
    </script>
  </xsl:template>
  
  <xsl:template match="thread-topic">
    <xsl:param name="indent"/>
    <tr>
    <td width="18">
      <xsl:choose>
        <xsl:when test="@status='active'">
          <img src="img/f_norm.gif" border="0" height="12" width="18" onmouseover="hintActive();" onmouseout="nd();"/>
        </xsl:when>
        <xsl:otherwise>
          <img src="img/f_closed.gif" border="0" height="12" width="18" onmouseover="hintClosed();" onmouseout="nd();"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td width="1" height="14"><br/></td>
    <td class="wtext">
    <div style="margin-left:{$indent}px; text-align:left;">
    <xsl:choose>
      <xsl:when test="@current='true'">
        <xsl:value-of select='@subject'/>
      </xsl:when>
      <xsl:otherwise>
        <a href="forum_intopic.jsp?topicId={@id}" class="bylink"><xsl:value-of select='@subject'/></a>
      </xsl:otherwise>
    </xsl:choose>
    </div>
    </td>
    <td width="1" height="14"><br/></td>
    <td class="wtext">
      <xsl:value-of select='@author'/>
    </td>
    <td width="1" height="14"><br/></td>
    <td class="wtext">
      <xsl:value-of select='@posted'/>
    </td>
    </tr>
    <tr>
      <td height="1" colspan="99" bgcolor="#ffa000"><img src="img/sp.gif" width="1" height="1"/></td>
    </tr>
    <xsl:apply-templates select='thread-topic'>
      <xsl:with-param name='indent' select='$indent + 10'/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="thread">
    <xsl:call-template name="hint-script"/>
    <table border="0" cellpadding="0" cellspacing="0" width="509">
    <tr>
      <td width="18" height="14" bgcolor="#ffa000"><br/></td>
      <td width="1"  height="14"><br/></td>
      <td width="288" height="14" class="btext" bgcolor="#ffa000" align="center">Subject</td>
      <td width="1"  height="14"><br/></td>
      <td width="100" height="14" class="btext" bgcolor="#ffa000" align="center">Author</td>
      <td width="1"  height="14"><br/></td>
      <td width="100" height="14" class="btext" bgcolor="#ffa000" align="center">Posted</td>
    </tr>
    <xsl:apply-templates select="thread-topic">
      <xsl:with-param name='indent' select='5'/>
    </xsl:apply-templates>
    </table>
  </xsl:template>

  <xsl:template match="topic">
    <style>
    .mrg {margin-left:7px; margin-right:7px;}
    </style>
    <table border="0" cellpadding="0" cellspacing="0" width="509">
    <tr>
      <td width="90" height="14" class="btext" bgcolor="#ffa000"><div class="mrg">Author:</div></td>
      <td width="1" height="14"><img src="img/sp.gif" width="1" height="14"/></td>
      <td width="418" height="14" class="wtext" bgcolor="#ffa000"><div class="mrg"><xsl:value-of select='@author'/></div></td>
    </tr>
    <tr>
      <td height="1" colspan="5"><img src="img/sp.gif" width="1" height="1"/></td>
    </tr>
    <tr>
      <td width="90" height="14" class="btext" bgcolor="#ffa000"><div class="mrg">Posted:</div></td>
      <td width="1" height="14"><img src="img/sp.gif" width="1" height="14"/></td>
      <td width="418" height="14" class="wtext" bgcolor="#ffa000"><div class="mrg"><xsl:value-of select='@posted'/></div></td>
    </tr>
    <tr>
      <td height="1" colspan="5"><img src="img/sp.gif" width="1" height="1"/></td>
    </tr>
    <tr>
      <td width="90" height="14" class="btext" bgcolor="#ffa000"><div class="mrg">Viewed:</div></td>
      <td width="1" height="14"><img src="img/sp.gif" width="1" height="14"/></td>
      <td width="418" height="14" class="wtext" bgcolor="#ffa000"><div class="mrg"><xsl:value-of select='@viewed'/> times</div></td>
    </tr>
    <tr>
      <td height="1" colspan="5"><img src="img/sp.gif" width="1" height="1"/></td>
    </tr>
    <tr>
      <td width="90" height="14" class="btext" bgcolor="#ffa000"><div class="mrg">Subject:</div></td>
      <td width="1" height="14"><img src="img/sp.gif" width="1" height="14"/></td>
      <td width="418" height="14" class="wtext" bgcolor="#ffa000"><div class="mrg"><xsl:value-of select='@subject'/></div></td>
    </tr>

    </table>
    <table border="0" cellpadding="0" cellspacing="0" width="509">
      <tr>
        <td height="1" background="img/h_dot.jpg" colspan="3"><img src="img/sp.gif" width="1" height="1"/></td>
      </tr>
      <tr>
        <td background="img/v_dot.jpg" width="1"><img src="img/sp.gif" width="1" height="20"/></td>
        <td><div class="btext" style="margin: 8px 8px 8px 8px;"><xsl:apply-templates/></div></td>
        <td background="img/v_dot.jpg" width="1"><img src="img/sp.gif" width="1" height="20"/></td>
      </tr>
      <tr>
        <td height="1" background="img/h_dot.jpg" colspan="3"><img src="img/sp.gif" width="1" height="1"/></td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="paginator">
    <table><tr><td class="wtext">Page:</td>
    <xsl:for-each select="/topics/topic">
      <xsl:if test="(position() - 1) mod $topicsPerPage = 0">
        <xsl:variable name="n" select="((position() - 1) div $topicsPerPage) + 1"/>
        <td class="wtext">
        <xsl:choose>
          <xsl:when test="$n = $page">
            <b><xsl:value-of select="$n"/></b>
          </xsl:when>
          <xsl:otherwise>
            <a class="bylink" href="javascript:gotoPage({$n})"><xsl:value-of select="$n"/></a>
          </xsl:otherwise>
        </xsl:choose>
        </td>
      </xsl:if>
    </xsl:for-each>
    </tr></table>
  </xsl:template>

  <xsl:template match="topics">
    <xsl:variable name="cnt" select="count(topic)" />
    <xsl:if test="$cnt &gt; $topicsPerPage">
      <form name="paginatorForm" method="get" style="position:absolute;"> 
      <xsl:for-each select="pgn:parameter">
        <input type="hidden" name="{@name}" value="{@value}"/>
      </xsl:for-each>
      </form>
      <script>
        function gotoPage(num) {
          document.paginatorForm.page.value = num;
          document.paginatorForm.submit();
        }
      </script>
      <xsl:call-template name="paginator"/>
    </xsl:if>
    <xsl:call-template name="hint-script"/>
    <table border="0" cellpadding="0" cellspacing="0" width="509">
    <tr>
      <td width="197" background="img/bg_ftabtit.gif" style="text-indent:1em;" class="btext">Subject</td>
      <td width="1" height="16"><img src="img/sp.gif" width="1" height="16"/></td>
      <td width="200" background="img/bg_ftabtit.gif" align="center" class="btext">Created</td>
      <td width="1" height="16"><img src="img/sp.gif" width="1" height="16"/></td>
      <td width="55" background="img/bg_ftabtit.gif" align="center" class="btext">Replies</td>
      <td width="1" height="16"><img src="img/sp.gif" width="1" height="16"/></td>
      <td width="55" background="img/bg_ftabtit.gif" align="center" class="btext">Viewed</td>
    </tr>
    </table>
    <table border="0" cellpadding="0" cellspacing="0" width="509">
    <xsl:variable name="firstTopic" select="($page - 1) * $topicsPerPage + 1" />
    <xsl:variable name="lastTopic" select="($page - 1) * $topicsPerPage + $topicsPerPage" />
    <xsl:for-each select="topic[(position() &gt;= $firstTopic) and ((position() &lt;= $lastTopic))]">
      <tr>
        <xsl:if test="position() mod 2 = 0">
          <xsl:attribute name="bgcolor">#ff7100</xsl:attribute>
        </xsl:if>
        <td width="18" valign="middle">
          <xsl:choose>
            <xsl:when test="@status='active'">
              <img src="img/f_norm.gif" border="0" height="12" width="18" onmouseover="hintActive();" onmouseout="nd();"/>
            </xsl:when>
            <xsl:otherwise>
              <img src="img/f_closed.gif" border="0" height="12" width="18" onmouseover="hintClosed();" onmouseout="nd();"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td width="7" height="16"><img src="img/sp.gif" width="1" height="16"/></td>
        <td width="176"><a href="forum_intopic.jsp?topicId={@id}" class="bylink"><xsl:value-of select='@subject'/></a></td>
        <td width="1" height="16"><img src="img/sp.gif" width="1" height="16"/></td>
        <td width="200" height="17" class="wtext"><xsl:value-of select='@posted'/><br/>by <xsl:value-of select='@author'/></td>
        <td width="1" height="16"><img src="img/sp.gif" width="1" height="16"/></td>
        <td width="55" height="17" align="center" class="wtext"><xsl:value-of select='@messages'/></td>
        <td width="1" height="16"><img src="img/sp.gif" width="1" height="16"/></td>
        <td width="55" height="17" align="center" class="wtext"><xsl:value-of select='@viewed'/></td>
      </tr>
      <tr>
        <td height="1" colspan="9" bgcolor="#ffa000"><img src="img/sp.gif" width="1" height="1"/></td>
      </tr>
    </xsl:for-each>
    </table>
    <xsl:if test="$cnt &gt; $topicsPerPage">
      <xsl:call-template name="paginator"/>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
