<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- make sure '<' is not printed as '&lt;' -->
  <xsl:output disable-output-escaping='true'/>
  <xsl:output method="html"/>
  <xsl:output indent="yes"/>

  <!-- copy input to output -->
  <xsl:template match='*|@*'>
    <xsl:copy>
      <xsl:apply-templates select='node()|@*'/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="brains-list">
    <table width="100%" border="1" cellpadding="5" cellspacing="0">
    <tr>
      <th bgcolor="#CCCCCC">specialty</th>
      <th bgcolor="#CCCCCC">name</th>
      <th bgcolor="#CCCCCC">author</th>
      <th bgcolor="#CCCCCC">file</th>
      <th bgcolor="#CCCCCC">size</th>
      <th bgcolor="#CCCCCC">visible</th>
      <th bgcolor="#CCCCCC"><br/></th>
    </tr>
    <xsl:for-each select="brain">
      <tr valign="top">
        <td><xsl:value-of select='@specialty'/></td>
        <td><a href="brain_edit.jsp?brainId={@id}"><xsl:value-of select='@name'/></a></td>
        <td><xsl:value-of select='@author'/></td>
        <td>
          <xsl:if test="@file-exists = 'false'">
            <xsl:attribute name="style">text-decoration:line-through; color:red;</xsl:attribute>
          </xsl:if>
          <xsl:value-of select='@file'/>
        </td>
        <td><xsl:value-of select='@size'/></td>
        <td><xsl:value-of select='@visible'/></td>
        <td><button onClick="javascript:return delBrain({@id});">Delete</button></td>
      </tr>        
    </xsl:for-each>
    </table>
  </xsl:template>

  <xsl:template match="specialty-selector">
    <option value="0"></option>
    <xsl:for-each select="specialty">
      <option value="{@id}">
        <xsl:if test="@selected = 'true'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:value-of select='@name'/>
      </option>
    </xsl:for-each>
  </xsl:template>

</xsl:stylesheet>
