<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- make sure '<' is not printed as '&lt;' -->
  <xsl:output disable-output-escaping='true'/>
  <xsl:output method="html"/>
  <xsl:output indent="yes"/>

  <!-- copy input to output -->
  <xsl:template match='*|@*'>
    <xsl:copy>
      <xsl:apply-templates select='node()|@*'/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="bookshelf">
    <script>var ol_width = 250;</script>
    <center>
    <table border="0" cellspacing="0" cellpadding="0" width="509" background="/img/books_bgr.jpg">
    <tr><td><br/></td></tr>
    <tr><td align="center">
    <xsl:for-each select="specialty">
      <table border="0" width="394" height="148" cellspacing="0" cellpadding="0" background="/img/book_shelf.jpg">
      <tr><td><img src="/img/sp.gif" height="3"/></td></tr>
      <tr><td valign="top" align="center" height="20" colspan="99">
        <table border="0" cellspacing="0" cellpadding="0" style="background-color:#FFFF00;">
          <tr>
          <td valign="center" align="left" width="15"><img src="/img/nail.gif"/></td>
          <td class="btext" style="background-color:#FFFF00;">
            <b><xsl:value-of select='@name'/></b>
          </td>
          <td valign="center" align="right" width="15"><img src="/img/nail.gif"/></td>
          </tr>
        </table>
      </td></tr>
      <tr><td valign="top" align="center">
      <xsl:for-each select="brain">
          <span id="h_{@id}" class="hdn">
            <b>Name: </b><xsl:value-of select='@name'/><br/>
            <b>File: </b><xsl:value-of select='@file'/><br/>
            <b>Size: </b><xsl:value-of select='@size'/><br/>
            <b>Author: </b><xsl:value-of select='@author'/><br/>
            <b>Created: </b><xsl:value-of select='@created'/><br/>
            <xsl:if test="@created != @updated">
              <b>Updated: </b><xsl:value-of select='@updated'/><br/>
            </xsl:if>
            <xsl:if test="@description != ''">
              <b>Description: </b><xsl:value-of select='@description'/><br/>
            </xsl:if>
            <br/>Click for download...
          </span>
          <a href="/brains/{@file}" onmouseover="hint(document.getElementById('h_{@id}').innerHTML);" onmouseout="nd();"><img border="0" src="img/book{@image-number}.gif"/></a>
      </xsl:for-each>
      </td></tr>
      </table>
    </xsl:for-each>
    </td></tr>
    <tr><td><br/></td></tr>
    </table>
    </center>
  </xsl:template>

</xsl:stylesheet>
