package xml;

import java.util.*;
import javax.servlet.http.*;
import com.caucho.xsl.*;
import com.caucho.transform.*;
import org.w3c.dom.*;

public class XMLTransformer {

  public static String transform(String xslName, Document doc) throws Exception {
    StylesheetFactory factory = new Xsl();
    xslName = Thread.currentThread().getContextClassLoader().getResource(xslName).toString();
    Stylesheet style = factory.newStylesheet(xslName);
    StringTransformer transformer = style.newStringTransformer();
    return transformer.transform(doc);
  }

  private static void addPgnParam(Node node, String name, String value) {
    Document doc = node.getOwnerDocument();
    Element el = doc.createElement("pgn:parameter");
    node.appendChild(el);
    el.setAttribute("name", name);
    el.setAttribute("value", value);
  }

  public static String transform(String xslName, Document doc, HttpServletRequest request) throws Exception {
    Node root = doc.getFirstChild();
    Enumeration enum = request.getParameterNames();
    String page = null;
    while (enum.hasMoreElements()) {
      String name = (String)enum.nextElement();
      String value = request.getParameter(name);
      if ("page".equals(name)) page = value;
      addPgnParam(root, name, value);
    }
    if (page == null) {
      page = "1";
      addPgnParam(root, "page", page);
    }
    StylesheetFactory factory = new Xsl();
    xslName = Thread.currentThread().getContextClassLoader().getResource(xslName).toString();
    Stylesheet style = factory.newStylesheet(xslName);
    StringTransformer transformer = style.newStringTransformer();
    transformer.setParameter("page", page);
    return transformer.transform(doc);
  }

}
