package util.template;

public abstract class AbstractMatcher {

  protected abstract String getPrefix();

  protected abstract String getValue(String postfix);

  public boolean check(String value) {
    return value.startsWith(getPrefix());
  }

  public String match(String value) {
    String result = getValue(value.substring(getPrefix().length()));
    if (result == null)
      return "[UNKNOWN]";
    else
      return result;
  }

}