package util;

import java.util.*;

public class TextProcessor {

  static public String postProcess(String text) {
    TextProcessor p = new TextProcessor();

    text = p.replace(text, "<img src=\"emoticons/smile.gif\" width=15 height=15 border=0>", ":)");
    text = p.replace(text, "<img src=\"emoticons/frown.gif\" width=15 height=15 border=0>", ":(");
    text = p.replace(text, "<img src=\"emoticons/alien.gif\" width=15 height=15 border=0>", "0]");
    text = p.replace(text, "<img src=\"emoticons/glasses.gif\" width=15 height=15 border=0>", "8)");
    text = p.replace(text, "<img src=\"emoticons/nerd.gif\" width=15 height=15 border=0>", "8o");
    text = p.replace(text, "<img src=\"emoticons/tongue.gif\" width=15 height=15 border=0>", ":b");
    text = p.replace(text, "<img src=\"emoticons/happy.gif\" width=15 height=15 border=0>", ":D");
    text = p.replace(text, "<img src=\"emoticons/embarassed.gif\" width=15 height=15 border=0>", ":o");
    text = p.replace(text, "<img src=\"emoticons/wink.gif\" width=15 height=15 border=0>", ";)");

    text = p.replace(text, "<br>", System.getProperty("line.separator"));
    text = p.replace(text, "&#62;", ">");
    text = p.replace(text, "&#60;", "<");
    return text;
  }

  static public String reply(String text) {
    String separator = System.getProperty("line.separator");
    StringTokenizer t = new StringTokenizer(text, separator, false);
    StringBuffer result = new StringBuffer();
    while (t.hasMoreTokens()) {
      String str = t.nextToken();
      result.append(str.startsWith(">") ? ">" : "> ")
            .append(str)
            .append(separator);
    }
    return result.toString();
  }

  static public String preProcess(String text) {
    TextProcessor p = new TextProcessor();

    text = p.replace(text, "<", "&#60;");
    text = p.replace(text, ">", "&#62;");
    text = p.replace(text, System.getProperty("line.separator"), "<br>");

    text = p.replace(text, ":)", "<img src=\"emoticons/smile.gif\" width=15 height=15 border=0>");
    text = p.replace(text, ":(", "<img src=\"emoticons/frown.gif\" width=15 height=15 border=0>");
    text = p.replace(text, "0]", "<img src=\"emoticons/alien.gif\" width=15 height=15 border=0>");
    text = p.replace(text, "8)", "<img src=\"emoticons/glasses.gif\" width=15 height=15 border=0>");
    text = p.replace(text, "8o", "<img src=\"emoticons/nerd.gif\" width=15 height=15 border=0>");
    text = p.replace(text, ":b", "<img src=\"emoticons/tongue.gif\" width=15 height=15 border=0>");
    text = p.replace(text, ":D", "<img src=\"emoticons/happy.gif\" width=15 height=15 border=0>");
    text = p.replace(text, ":o", "<img src=\"emoticons/embarassed.gif\" width=15 height=15 border=0>");
    text = p.replace(text, ";)", "<img src=\"emoticons/wink.gif\" width=15 height=15 border=0>");

    return text;
  }

  private String replace(String text, String find, String replace) {
    for (int n = text.indexOf(find); n >= 0; n = text.indexOf(find, n + replace.length()))
      text = text.substring(0, n) + replace + text.substring(n + find.length());
    return text;
  }

  public static String normStr(String str) {
    if (str == null)
      return "";
    else
      return str.trim();
  }

}