package servlet;

import ejb.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.caucho.vfs.*;

public final class NewsAnnounce extends HttpServlet {

  private static final String SUBJECT = "AI Agent news digest";
  
  public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    ServletOutputStream out = response.getOutputStream();
    Date lastPost = null;

    try {
      News news = EJBGetter.getNewsHome().findLast();
      lastPost = news.getPosted();
    } catch (Exception ex) {
    }

    if (lastPost != null) {
      try {
        MailSender mail = EJBGetter.getMailSenderHome().create();
        try {
          Iterator subsIter = EJBGetter.getSubscriberHome().findForAnnounce(lastPost).iterator();
          SubscribeCtrl subsCtrl = EJBGetter.getSubscribeCtrlHome().create();
          String from = System.getProperty("mail.news");
          while (subsIter.hasNext()) {
            Subscriber subs = (Subscriber)subsIter.next();
            String url = System.getProperty("site.url") + "templates/announceTemplate";
            if (subs.getFormat() == subs.FORMAT_TEXT)
              url += "Text";
            else if (subs.getFormat() == subs.FORMAT_HTML)
              url += "HTML";
            else
              throw new ServletException("unknown subscription format");
            url += ".jsp?subscriberId=" + subs.getId();
            ReadStream rs = Vfs.openRead(url);
            String str;
            StringBuffer buf = new StringBuffer();
            while ((str = rs.readLine()) != null) {
              if ((buf.length() > 0) || (! "".equals(str)))
                buf.append(str).append("\r\n");
            }
            out.println(buf.toString());
            try {
              if (subs.getFormat() == subs.FORMAT_TEXT)
                mail.sendText(from, subs.getEmail(), SUBJECT, buf.toString());
              else if (subs.getFormat() == subs.FORMAT_HTML)
                mail.sendHTML(from, subs.getEmail(), SUBJECT, buf.toString());
              else
                throw new ServletException("unknown subscription format");            
            } catch (MailSenderException ex) {
              throw new SubscribeCtrlException(ex.getMessage(), ex);
            }
            subs.setNoticed(lastPost);
          }
          subsCtrl.remove();
        } finally {
          mail.remove();
        }
      } catch(Exception ex) {
        throw new ServletException("", ex);
      }
    }
  }

}
