package servlet;

import ejb.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import Acme.JPM.Encoders.*;
import com.eteks.java2d.*;
import com.eteks.awt.*;
import java.awt.*;
import com.caucho.util.ClassLoaderLocal;
import com.caucho.util.LruCache;

public final class Button extends HttpServlet {

  private static ClassLoaderLocal ctx = new ClassLoaderLocal();

  private LruCache getCache() {
    LruCache cache = (LruCache)ctx.get();
    if (cache == null) {
      cache = new LruCache(20);
      ctx.set(cache);
    }
    return cache;
  }

  private ByteArrayOutputStream getImage(String caption) {
    return (ByteArrayOutputStream)getCache().get(caption);
  }

  private void putImage(String caption, ByteArrayOutputStream image) {
    getCache().put(caption, image);
  }

  public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    response.setContentType("image/gif");
    ServletOutputStream out = response.getOutputStream();
    String caption = request.getParameter("caption");
    if (caption == null) {
      caption = request.getRequestURI();
      caption = caption.substring(caption.indexOf("/btn/") + 5);
      int n = caption.indexOf(".gif");
      if (n >= 0) caption = caption.substring(0, n);
      caption = caption.replace('_', ' ');
    }
    ByteArrayOutputStream bout;
    bout = getImage(caption);
    if (bout == null) {
      int w = 77, h = 20;
      System.setProperty("java.awt.fonts", request.getRealPath("../WEB-INF/font"));
      PJAImage img = new PJAImage(w, h);
      PJAGraphics g = (PJAGraphics)img.getGraphics();
      g.setFont("Tahoma", Font.BOLD, 11);
      int sw = g.getStringWidth(caption);
      if (w < (sw  + 16)) {
        w = sw + 16;
        img = new PJAImage(w, h);
        g = (PJAGraphics)img.getGraphics();
      }
  
      g.setColor(new Color(0xFF7F00));
      g.fillRect(0, 0, w, h);
  
      g.setColor(new Color(0xFFEBD9));
      g.setFont("Tahoma", Font.BOLD, 11);
      g.drawString(caption, ((w - sw) / 2), 14);
      g.setColor(new Color(0xFFDD00));
      g.drawRoundRect(0, 0, w-1, h-1, 8, 8);
  
      bout = new ByteArrayOutputStream();
      new GifEncoderNoCM(img, bout).encode();
      putImage(caption, bout);
    }
    response.setContentLength(bout.size());
    bout.writeTo(out);
    out.flush();
  }
}