package security;

/*
 * $Log: Authenticator.java,v $
 * Revision 1.2  2002/11/18 22:52:17  paul
 * + Log keyword added
 *
 */

import java.util.*;
import java.security.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.caucho.http.security.*;
import ejb.*;

public class Authenticator extends AbstractAuthenticator {

  public static final String ROLE_ADMIN = "admin";
  public static final String ROLE_USER = "user";

  protected Principal loginImpl(HttpServletRequest request, HttpServletResponse response,
                                ServletContext application, String user, String password) throws ServletException {
    Principal principal = null;
    try {
      User userPrincipal = EJBGetter.getUserHome().findByLogin(user);
      if (password.equals(userPrincipal.getPassword())) {
        userPrincipal.setPrevLogin(userPrincipal.getCurrLogin());
        userPrincipal.setCurrLogin(new Date());
        userPrincipal.setPrevAddress(userPrincipal.getCurrAddress());
        userPrincipal.setCurrAddress(request.getRemoteAddr());
        principal = userPrincipal;
      }
    } catch (Exception ex) {}

    return principal;
  }
  
  public boolean isUserInRole(HttpServletRequest request, HttpServletResponse response,
                              ServletContext application, Principal user, String role) throws ServletException {

    if (user == null)
      return false;
    if (role.equalsIgnoreCase(ROLE_USER))
      return true;
    else if (role.equalsIgnoreCase(ROLE_ADMIN) && ((User)user).getLogin().equalsIgnoreCase(ROLE_ADMIN))
      return true;
    else
      return false;
  }

}