package filter;

import ejb.*;
import util.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.caucho.vfs.*;

public class Download implements Filter {

  private static final String C_NAME = "download-name";
  private static final String C_EMAIL = "download-email";
  private static int MAX_COOKIE_AGE = 2592000; // 30 days

  public void init(FilterConfig config) throws ServletException {
  }
  
  public void destroy() {
  }

  private DownloadCtrl getDownloadCtrl(HttpServletRequest request) {
    HttpSession session = request.getSession();
    DownloadCtrl result;
    result = (DownloadCtrl)session.getAttribute("downloadCtrl");
    if (result == null) {
      String name = CookieUtil.getString(request, C_NAME);
      String email = CookieUtil.getString(request, C_EMAIL);
      if ((name != null) && (email != null)) {
        try {
          result = EJBGetter.getDownloadCtrlHome().create(name, email);
          synchronized (session) {
            session.setAttribute("downloadCtrl", result);
          }
        } catch (Exception ex) {
          ex.printStackTrace();
          result = null;
        }
      }
    }
    return result;
  }

  private boolean fromStart(HttpServletRequest request) {
    String range;
    range = request.getHeader("Range");
    if (range == null)
      request.getHeader("Request-Range");
    if (range == null) {
      return true;
    } else {
      return range.startsWith("bytes=0-");
    }
  }

  public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
    HttpServletRequest req = (HttpServletRequest)request;

    String agent = req.getHeader("User-Agent");
    if ((agent != null) && (agent.matches("^AIAgent.*"))) {
      nextFilter.doFilter(request, response);
      return;
    }

    HttpServletResponse res = (HttpServletResponse)response;
    HttpSession session = req.getSession();
    synchronized (session) {
      String file = TextProcessor.normStr(req.getRequestURI());
      file = com.caucho.util.URLUtil.encodeURL(file);
      DownloadCtrl dlCtrl = getDownloadCtrl(req);
      if (dlCtrl == null) {
        res.sendRedirect(System.getProperty("site.url") + "download_form.jsp?file=" + file);
      } else {
        res.setDateHeader("Expires", 0);
        res.setHeader("Cache-Control", "no-cache, must-revalidate");
        res.setHeader("Pragma", "no-cache");
        if (fromStart(req)) {
          Cookie cookie;
          cookie = new Cookie(C_NAME, dlCtrl.getName());
          cookie.setMaxAge(MAX_COOKIE_AGE);
          res.addCookie(cookie);
          cookie = new Cookie(C_EMAIL, dlCtrl.getEmail());
          cookie.setMaxAge(MAX_COOKIE_AGE);
          res.addCookie(cookie);
          dlCtrl.registerDownload(file, req.getRemoteAddr());
        }
        nextFilter.doFilter(request, response);
      }
    }
  }

}
