package ejb;

import util.*;
import java.io.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.caucho.ejb.*;
import javax.servlet.http.*;

public class UserCtrlBean extends AbstractSessionBean {

  public void ejbCreate() throws CreateException { }

  public User registerUser(HttpServletRequest request) throws EJBException {

    String login = TextProcessor.normStr(request.getParameter("login"));
    String password1 = TextProcessor.normStr(request.getParameter("password1"));
    String password2 = TextProcessor.normStr(request.getParameter("password2"));
    String name = TextProcessor.normStr(request.getParameter("name"));
    String email = TextProcessor.normStr(request.getParameter("email"));

    if (login.length() == 0)
      throw new UserCtrlException("login required");
    if (password1.length() == 0)
      throw new UserCtrlException("password required");
    if (password2.length() == 0)
      throw new UserCtrlException("password confirmation required");
    if (!password1.equals(password2))
      throw new UserCtrlException("incorrect password confirmation");
    if (email.length() == 0)
      throw new UserCtrlException("email required");
    if ((email.indexOf('@') < 0) || (email.indexOf('.') < 0))
      throw new UserCtrlException("invalid email format");
    try {
      return EJBGetter.getUserHome().create(login, password1, name, email);
    } catch(CreateException ex) {
      throw new UserCtrlException(ex.getMessage());
    }
  }

  public User updateUser(HttpServletRequest request) throws EJBException {
    String password1 = TextProcessor.normStr(request.getParameter("password1"));
    String password2 = TextProcessor.normStr(request.getParameter("password2"));
    String name = TextProcessor.normStr(request.getParameter("name"));
    String email = TextProcessor.normStr(request.getParameter("email"));
    return null;
  }

  public void removeUser(User user) throws EJBException {
    try {
      User dead = EJBGetter.getUserHome().findByPrimaryKey(User.DEAD_ID);
      Iterator iter = EJBGetter.getTopicHome().findByUser(user).iterator();
      while (iter.hasNext()) {
        Topic t = (Topic)iter.next();
        System.out.println("user.remove topic: " + t.toString());
        t.setUser(dead);
      }
    } catch (FinderException ex) {
      System.out.println("user.remove FinderException: " + ex.getMessage());
    }
  }

  public void removeUser(int id) throws EJBException {
  }

  public User getAnonymous() throws UserCtrlException {
    try {
      return EJBGetter.getUserHome().findByLogin(User.ANONYMOUS_LOGIN);
    } catch(FinderException ex) {
      throw new UserCtrlException(ex.getMessage());
    }
  }

}
