package ejb;

/*
 * $Log: UserBean.java,v $
 * Revision 1.2  2002/11/18 22:51:55  paul
 * + Log keyword added
 *
 */

import javax.ejb.*;
import javax.naming.*;
import java.util.*;
import com.caucho.ejb.*;
import com.caucho.http.security.*;

public abstract class UserBean extends AbstractEntityBean {


  public abstract int getId();

  public abstract String getLogin();
  public abstract void setLogin(String login);

  public abstract String getPassword();
  public abstract void setPassword(String password);

  public abstract String getName();
  public abstract void setName(String name);

  public abstract String getEmail();
  public abstract void setEmail(String email);

  public abstract Date getRegistered();
  public abstract void setRegistered(Date registered);

  public abstract String getPrevAddress();
  public abstract void setPrevAddress(String value);

  public abstract Date getPrevLogin();
  public abstract void setPrevLogin(Date value);

  public abstract String getCurrAddress();
  public abstract void setCurrAddress(String value);

  public abstract Date getCurrLogin();
  public abstract void setCurrLogin(Date value);

  public int ejbCreate(String login, String password, String name, String email) throws CreateException {
    try {
      UserHome home = (UserHome)getEntityContext().getEJBLocalHome();
      if (home.findByLogin(login) != null)
        throw new CreateException(login + " is a duplicate user.");
    } catch (FinderException e) { }

    setLogin(login);
    setPassword(password);
    setName(name);
    setEmail(email);
    setRegistered(new Date());
    setCurrAddress("[unknown]");
    setPrevAddress("[unknown]");
    return 0;
  }

  public void ejbPostCreate(String login, String password, String name, String email) { }

  public void ejbRemove() throws RemoveException { }

  public String getFullName() {
    if ("".equals(getName()))
      return getLogin();
    else
      return getName();
  }

  public boolean isAnonymous() {
    return User.ANONYMOUS_LOGIN.equals(getLogin());
  }

  public boolean isAdmin() {
    return User.ADMIN_LOGIN.equals(getLogin());
  }

  public boolean equals(Object obj) {
    if ((obj instanceof User) && (obj != null))
      return getId() == ((User)obj).getId();
    else
      return false;
  }

  public String toString() {
    return "[User id=" + getId() + " Name: \"" + getName() + "\" Email: " + getEmail() +"]";
  }
}
