package ejb;

/*
 * $Log: User.java,v $
 * Revision 1.2  2002/11/18 22:51:55  paul
 * + Log keyword added
 *
 */

import javax.ejb.*;
import javax.naming.*;
import java.util.*;
import java.security.*;

public interface User extends EJBLocalObject, Principal {

  public static final int ADMIN_ID = 1;
  public static final int ANONYMOUS_ID = 2;
  public static final int DEAD_ID = 3;

  public static final String ANONYMOUS_LOGIN = "anonymous";
  public static final String ADMIN_LOGIN = "admin";

  public int getId();

  public String getLogin();
  public void setLogin(String login);

  public String getPassword();
  public void setPassword(String password);

  public String getName();
  public void setName(String name);

  public String getEmail();
  public void setEmail(String email);

  public Date getRegistered();
  public void setRegistered(Date registered);

  public String getPrevAddress();
  public void setPrevAddress(String value);

  public Date getPrevLogin();
  public void setPrevLogin(Date value);

  public String getCurrAddress();
  public void setCurrAddress(String value);

  public Date getCurrLogin();
  public void setCurrLogin(Date value);

  public String getFullName();

  public boolean isAnonymous();

  public boolean isAdmin();

  public boolean equals(Object obj);

  public String toString();

}
