package ejb;

/*
 * $Log: TopicBean.java,v $
 * Revision 1.2  2002/11/18 22:51:55  paul
 * + Log keyword added
 *
 */

import javax.ejb.*;
import javax.naming.*;
import java.util.*;
import com.caucho.ejb.*;

public abstract class TopicBean extends AbstractEntityBean {

  public abstract int getId();

  public abstract Topic getParent();
  public abstract void setParent(Topic topic);

  public abstract Forum getForum();
  public abstract void setForum(Forum forum);

  public abstract User getUser();
  public abstract void setUser(User user);

  public abstract String getSubject();
  public abstract void setSubject(String subject);

  public abstract String getText();
  public abstract void setText(String text);

  public abstract Date getPosted();
  public abstract void setPosted(Date posted);

  public abstract int getViewed();
  public abstract void setViewed(int viewed);

  public abstract boolean getActive();
  public abstract void setActive(boolean active);

  public boolean isEmptyStr(String str) {
    return ((str == null) || (str.trim().length() == 0));
  }

  public int ejbCreate(Forum forum, User user, String subject, String text) throws CreateException {
    if (isEmptyStr(subject) || isEmptyStr(text))
      throw new CreateException("Subject and topic text required");
    Date posted = new Date();
    forum.setLastPost(posted);
    setForum(forum);
    setUser(user);
    setSubject(subject);
    setText(text);
    setPosted(posted);
    setViewed(0);
    setActive(true);
    return 0;
  }

  public int ejbCreate(Topic parent, User user, String subject, String text) throws CreateException {
    if (isEmptyStr(subject) || isEmptyStr(text))
      throw new CreateException("Subject and topic text required");
    Date posted = new Date();
    parent.getForum().setLastPost(posted);
    setParent(parent);
    setForum(parent.getForum());
    setUser(user);
    setSubject(subject);
    setText(text);
    setPosted(posted);
    setViewed(0);
    setActive(true);
    return 0;
  }

  public void ejbPostCreate(Forum forum, User user, String subject, String text) { }

  public void ejbPostCreate(Topic parent, User user, String subject, String text) { }

  public void ejbRemove() throws RemoveException {
    TopicHome home = (TopicHome)getEntityContext().getEJBLocalHome();
    Iterator iter = null;
    try {
      iter = home.findChild((Topic)getEntityContext().getEJBLocalObject()).iterator();
    }
    catch (FinderException fe) {}
    if (iter != null) {
      while (iter.hasNext()) {
        ((Topic)iter.next()).remove();
      }
    }
  }

  public void ejbHomeCloseThread(Topic topic) throws FinderException {
    topic.setActive(false);
    Iterator iter = ((TopicHome)getEntityContext().getEJBLocalHome()).findChild(topic).iterator();
    while (iter.hasNext()) {
      ejbHomeCloseThread((Topic)iter.next());
    }    
  }

  public void ejbHomeOpenThread(Topic topic) throws FinderException {
    topic.setActive(true);
    Iterator iter = ((TopicHome)getEntityContext().getEJBLocalHome()).findChild(topic).iterator();
    while (iter.hasNext()) {
      ejbHomeOpenThread((Topic)iter.next());
    }    
  }

  private int getSubtopicsCount(Topic topic) throws FinderException {
    int result = 0;
    Collection col = ((TopicHome)getEntityContext().getEJBLocalHome()).findChild(topic);
    result += col.size();
    Iterator iter = col.iterator();
    while (iter.hasNext()) {
      result += getSubtopicsCount((Topic)iter.next());
    }
    return result;
  }

  public int getSubtopicsCount() {
    try {
      Topic topic = (Topic)getEntityContext().getEJBLocalObject();
      return getSubtopicsCount(topic);
    } catch (FinderException fe) {
      return 0;
    }
  }

  public Topic getRoot() {
    Topic topic = (Topic)getEntityContext().getEJBLocalObject();
    while (topic.getParent() != null) {
      topic = topic.getParent();
    }
    return topic;
  }

  public void incViewed() {
    setViewed(getViewed() + 1);
  }

  public boolean equals(Object obj) {
    if ((obj instanceof Topic) && (obj != null))
      return getId() == ((Topic)obj).getId();
    else
      return false;
  }

  public String toString() {
    return "[Id:" + getId() + " Subject:" + getSubject() + "]";
  }
}
